#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "psf_fopen.h"
#include "env_variables.h"
#include "tiltype.h"
#include "ptree.h"
#include "prtilparts.h"
#include "funcptree.h"
#include "fieldex.h"
#include "partree.h"
#include "printgraph.h"
#include "eqm.h"
#include "version.h"
#include "readtil.h"
#include "writetil.h"

extern int getopt PROTO_ARGS((int, char * PROTO_CONST *,  PROTO_CONST char *));
extern int optind;
extern char *optarg;

char *progname;
char *filename;
int Option_Debug = 0;
int Option_Combine = 0;
char *Option_GraphDir = NULL;
int Option_Unused = 0;
int Option_Sub = 0;
int Option_ExtendActions = 0;
int Option_RemoveDuplicates = 0;
int Option_NoIO = 0;
int Option_Heuristic = 0;
int Option_NoOrder = 0;
int Option_Table = 0;

#define USAGE	 "usage: %s file\n"

ptree **PT;

static char *mybasename(s)
    char *s;
{
    char *p, *q, *r;
    int n;

    n = strlen(s);
    p = &s[n];
    while (*p != '/' && p != s)
	p--;
    if (*p == '/')
	p++;
    n = strlen(p);
    q = &p[n];
    while (*q != '.' && q != p)
	q--;
    if (q != p)
	*q = '\0';
    r = psf_strdup(p);
    if (q != p)
	*q = '.';
    return (r);
}

struct module *Mod = NULL;
extern char *filename;

int read_til_spec(input)
    char *input;
{
    psf_file pf;
    static suffix suffixes[] = {{TILSUFFIX, TILSUFFIX_DEFAULT}, {NULL, NULL}};

    Mod = PSF_MALLOC(struct module);
    pf = psf_fopen(input, suffixes);
    filename = pf.name;
    Mod->name = mybasename(input);
    if (read_module(Mod, pf.fp)) {
	fclose(pf.fp);
	return (2);
    }
    fclose(pf.fp);
    return (0);
}

static void ProcessTree(m)
module *m;
{
    def_tuple *def = m->def;
    int nrdef = m->entries_table[DEF];
    ptree *pt;
    int i;

    set_print_current_module(m);
    set_print_output_file(stdout);
    Option_skipnr = TRUE;

    PT = PSF_NMALLOC(ptree *, nrdef + 1);
    for (i = 1; i <= nrdef; i ++) {
        pt = BuildPtree(&def[i].ae_t, &def[i].p_expr);
        /* PrintPtree(pt); */
	pt = RightAssocPtree(pt);
        /* PrintPtree(pt); */
	pt = EdgePtree(pt);
        /* PrintEdgePtree(pt); */
	pt = EdgeListPtree(pt);
        /* PrintEdgePtree(pt); */
	pt = EdgeNullPtree(pt);
        /* PrintEdgePtree(pt); */
	PT[i] = pt;
    }
}

eqm_t *Eqm;

    int pindex;

int main(argc, argv)
    int argc;
    char *argv[];
{
    char *pn;
    int opt;
    char *tilfile;
    partree *pt;
    int i;
    char *pname = "Main";
    int key;

    progname = psf_basename(pn = argv[0]);
    while ((opt = getopt(argc, argv, "cdeg:hnop:rstuv")) != -1) {
	switch (opt) {
	case 'c':
	    Option_Combine = 1;
	    break;
	case 'd':
	    Option_Debug = 1;
	    break;
	case 'e':
	    Option_ExtendActions = 1;
	    break;
	case 'g':
	    Option_GraphDir = optarg;
	    break;
	case 'h':
	    Option_Heuristic = 1;
	    break;
	case 'n':
	    Option_NoIO = 1;
	    break;
	case 'o':
	    Option_NoOrder = 1;
	    break;
	case 'p':
	    pname = optarg;
	    break;
	case 'r':
	    Option_RemoveDuplicates = 1;
	    break;
	case 's':
	    Option_Sub = 1;
	    break;
	case 't':
	    Option_Table = 1;
	    break;
	case 'u':
	    Option_Unused = 1;
	    break;
        case 'v':
            fprintf(stderr, "%s version %s, last compiled %s\n", progname,
                VERSION, __DATE__);
            exit(0);
	case '?':
	    exit(1);
	}
    }
    argc -= optind - 1;
    argv += optind - 1;

    if (argc != 2) {
	fprintf(stderr, USAGE, pn);
	exit(1);
    } else {
	tilfile = argv[1];
    }
    switch (read_til_spec(tilfile)) {
    case 0:
	break;
    case 1:
	fprintf(stderr, "%s: can't read file %s\n",
		pn, argv[1]);
	exit(1);
    case 2:
	fprintf(stderr, "%s: error in input-file\n", pn);
	exit(1);
    }

    write_til_init();

    pindex = 0;
    for (i = 1; i <= Mod->entries_table[DEF]; i ++) {
	key = Mod->def[i].ae_t.ind.key;
/* printf("%s\n", get_ff_field("n", Mod->pro[key].ff)); */
	if (!strcmp(get_ff_field("n", Mod->pro[key].ff), pname)) {
	    pindex = i;
	    break;
	}
    }
/* printf("p: %d\n", pindex); */
    if (pindex == 0) {
	fprintf(stderr, "%s: no process '%s' found\n", pn, pname);
	exit(1);
    }

    Eqm = create_eqm(Mod->entries_table[FUN]);
    for (i = 1; i <= Mod->entries_table[EQU]; i++)
        Eqm = add_equation(Eqm, Mod->equ[i]);

    ProcessTree(Mod);
    pt = BuildParPtree(pindex);

    if (Option_Table) {
	PrintTable(pt);
    } else {
	PrintGraph(pt);
    }

/*
    for (i = 1; i <= Mod->entries_table[DEF]; i ++) {
        DestroyPtree(PT[i]);
    }
    PrintAccountPtree();
    PrintAccountPedge();
    PrintAccountAtom();
*/

    exit(0);
}
