#include <stdio.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "ptree.h"
#include "funcptree.h"
#include "prtilparts.h"

ptree *RightAssocPtree(pt)
ptree *pt;
{
    pedge *e;
    ptree *c;

    if (pt->edge != NULL) {
	for (e = pt->edge; e != NULL; e = e->next) {
	    e->node = RightAssocPtree(e->node);
	}
	c = pt->edge->node;
	if (pt->fun == SEQ && c->fun == SEQ) {
	    pt->edge->node = c->edge->node;
	    c->edge->node = c->edge->next->node;
	    c->edge->next->node = pt->edge->next->node;
	    pt->edge->next->node = RightAssocPtree(c);
	}
    }
    return(pt);
}

static int IsAtom(pt)
ptree *pt;
{
    if (pt->fun == AET) {
	return(pt->pe->proc_expr.pe2.ind.table == ATM);
    } else {
	return(pt->fun == SKP);
    }
}

static int EdgeIsFree(e)
pedge *e;
{
    return(e->atom == NULL);
}

static void FreeNode(pt)
ptree *pt;
{
    pedge *e, *eh;

    for (e = pt->edge; e != NULL;) {
	eh = e;
	e = e->next;
	FreePedge(eh);
    }
    FreePtree(pt);
}

static atomlist *AddAtom(al, t)
atomlist *al;
process_expr *t;
{
    atomlist *a;

    a = AllocAtom();
    a->atom = t;
    a->next = al;
    return(a);
}

static atomlist *AddAtomLast(al, t)
atomlist *al;
process_expr *t;
{
    atomlist *a, *ah;

    a = AllocAtom();
    a->atom = t;
    a->next = NULL;
    if (al == NULL) {
	return(a);
    } else {
	for (ah = al; ah->next != NULL; ah = ah->next);
	ah->next = a;
	return(al);
    }
}

ptree *EdgePtree(pt)
ptree *pt;
{
    pedge *e, *eh;
    ptree *c;

    if (pt->edge != NULL) {
	for (e = pt->edge; e != NULL; e = e->next) {
	    c = e->node = EdgePtree(e->node);
	    if (c->fun == SEQ) {
		if (IsAtom(c->edge->node)) {
		    if (EdgeIsFree(c->edge->next)) {
			e->atom = AddAtom(e->atom, c->edge->node->pe);
			e->node = c->edge->next->node;
			FreePtree(c->edge->node);
			FreeNode(c);
		    } else {
			e->atom = AddAtom(e->atom, c->edge->node->pe);
			FreePtree(c->edge->node);
			eh = c->edge;
			c->edge = c->edge->next;
			FreePedge(eh);
		    }
		}
	    }
	}
    }
    return(pt);
}

atomlist *AddAtomList(l1, l2)
atomlist *l1, *l2;
{
    atomlist *a;

    if (l1 == NULL) {
	return(l2);
    } else {
	for (a = l1; a->next != NULL; a = a->next);
	a->next = l2;
	return(l1);
    }
}

ptree *EdgeListPtree(pt)
ptree *pt;
{
    pedge *e;
    ptree *c;

    if (pt->edge != NULL) {
	for (e = pt->edge; e != NULL; e = e->next) {
	    c = e->node = EdgeListPtree(e->node);
	    if (c->fun == SEQ && c->edge->next == NULL) {
		e->atom = AddAtomList(e->atom, c->edge->atom);
		e->node = c->edge->node;
		FreePedge(c->edge);
		FreePtree(c);
	    }
	}
    }
    return(pt);
}

ptree *EdgeNullPtree(pt)
ptree *pt;
{
    pedge *e;
    ptree *c;
    atomlist *a;

    if (pt->edge != NULL) {
	for (e = pt->edge; e != NULL; e = e->next) {
	    c = e->node = EdgeNullPtree(e->node);
	    if (IsAtom(c)) {
		e->atom = AddAtomLast(e->atom, c->pe);
		e->node = NullPtree;
		FreePtree(c);
	    }
	}
    }
    return(pt);
}

static int indent = 0;

/* c is of type char, but sun compiler complains of old style, etc */
void PrintProcessFunction(c)
int c;
{
    switch(c) {
    case ALT:
	printf("+"); break;
    case SEQ:
	printf("."); break;
    case PAR:
	printf("||"); break;
    case INTR:
	printf("interrupt"); break;
    case DISR:
	printf("disrupt"); break;
    case STAR:
	printf("*"); break;
    case SHARP:
	printf("#"); break;
    case SUM:
	printf("sum"); break;
    case MRG:
	printf("merge"); break;
    case ENC:
	printf("encaps"); break;
    case HID:
	printf("hide"); break;
    case IF:
	printf("if"); break;
    case PRIO:
	printf("prio"); break;
    case SKP:
	printf("skip"); break;
    default:
	printf("%c", c); break;
    }
}

void PrintAtomList(al)
atomlist *al;
{
    atomlist *a;

    printf(" [");
    for (a = al; a != NULL; a = a->next) {
	printf(" ");
	print_process_expr(a->atom);
	printf(" %d%d%d%d", a->props.sum, a->props.encaps, a->props.hide,
	    a->props.comm);
	if (a->props.pid != NULL)
	    printf("(%d)", a->props.pid->id);
    }
    printf(" ]");
}

void PrintCommList(cl)
commlist *cl;
{
    commlist *c;

    printf(" |");
    for (c = cl; c != NULL; c = c->next) {
	printf(" ");
	print_ae_term(c->comm);
	printf(" %d%d%d(%d-%d)", c->props.direction, c->props.encaps, c->props.hide, c->p1->id, c->p2->id);
    }
    printf(" |\n");
}

void PrintEdgePtree(pt)
ptree *pt;
{
    int i;
    pedge *e;
    atomlist *a;
    commlist *c;

/*
    if (pt == NullPtree) {
	printf("   ");
	PrintProcessFunction(pt->fun);
	return;
    }
*/
    if (pt->id != NULL) {
	printf("\n");
	for (i = 0; i < indent; i ++) {
	    printf(" ");
	}
	print_ae_term(pt->id);
	printf(" =");
	indent += 0;
    }
    if (pt->edge != NULL) {
	if (pt->fun != AET) {
	    printf("\n");
	    for (i = 0; i < indent; i ++) {
		printf(" ");
	    }
	    PrintProcessFunction(pt->fun);
	    if (pt->pid)
		printf("id:%d", pt->pid->id);
	    else
		printf("id:?");
	    if (pt->comm)
		PrintCommList(pt->comm);
	}
    } else {
	printf("\n");
	for (i = 0; i < indent; i ++) {
	    printf(" ");
	}
/*
	if (pt == NullPtree)
	    PrintProcessFunction(pt->fun);
	else
	    print_process_expr(pt->pe);
*/
	if (pt->fun == '\\')
	    PrintProcessFunction(pt->fun);
	else
	    print_process_expr(pt->pe);
    }
    indent += 4;
    for (e = pt->edge; e != NULL; e = e->next) {
	if (e != pt->edge) {
	    printf("\n");
	    for (i = 0; i < indent - 4 + 1; i ++) {
		printf(" ");
	    }
	}
	PrintAtomList(e->atom);
	PrintEdgePtree(e->node);
    }
    indent -= 4;
    if (pt->id != NULL) {
	indent -= 0;
	printf("\n");
    }
}
