#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "fieldex.h"
#include "ptree.h"
#include "eqm.h"
#include "main.h"
#include "openterm.h"
#include "prtilparts.h"

typedef struct plist {
    int key;
    struct plist *next;
} plist;

static int account = 0;

static plist *AllocPlist()
{
    account ++;
    return(PSF_MALLOC(plist));
}

static void FreePlist(pl)
plist *pl;
{
    PSF_FREE(pl);
}

static void PrintAccountPlist()
{
    fprintf(stderr, "Plist :: %d\n", account);
}

static plist *AddPlist(k, pl)
int k;
plist *pl;
{
    plist *new;

    new = AllocPlist();
    new->key = k;
    new->next = pl;
    account --;
    return(new);
}

static plist *SubPlist(pl)
plist *pl;
{
    plist *old;

    old = pl->next;
    FreePlist(pl);
    return(old);
}

static int InPlist(k, pl)
int k;
plist *pl;
{
    plist *h;

    for (h = pl; h != NULL; h = h->next) {
	if (h->key == k)
	    return(1);
    }
    return(0);
}

/* Should be openterm match */
static int MatchProcess(aet, sub)
ae_term *aet;
subst_t **sub;
{
    int i;

    for (i = 1; i <= Mod->entries_table[DEF]; i ++) {
	*sub = OpentermMatch(&Mod->def[i].ae_t, aet);
	if (*sub != NULL) {
	    return(i);
	}
    }
    return(0);
}

static int VarInSub(v, sub)
int v;
subst_t *sub;
{
    subst_elem_t *e;

    if (! sub)
	return(0);
    for (e = sub->sb_elems; e != NULL; e = e->next_se) {
	if (e->var.key == v)
	    return(1);
    }
    return(0);
}

static subst_t *DeleteFromSub(v, sub)
int v;
subst_t *sub;
{
    subst_elem_t *e1, *e2;

    e1 = NULL;
    for (e2 = sub->sb_elems; e2 != NULL; e2 = e2->next_se) {
	if (e2->var.key == v) {
	    if (e1 == NULL) {
		sub->sb_elems = e2->next_se;
	    } else {
		e1->next_se = e2->next_se;
	    }
	    /* should free elem */
	    return(sub);
	}
	e1 = e2;
    }
    return(sub);
}

static subst_t *FilterSubs(pd, aet, sub, msub)
int pd;
ae_term *aet;
subst_t *sub;
subst_t *msub;
{
    int i;
    ae_term *maet;

    maet = &Mod->def[pd].ae_t;
    for (i = 0; i < aet->a; i ++) {
	if ((aet->ae_list[i].ind.table == VAR) &&
	    (maet->ae_list[i].ind.table == VAR)) {
	    if (VarInSub(aet->ae_list[i].ind.key, sub)) {
		continue;
	    }
	}
	if (maet->ae_list[i].ind.table == VAR)
	    msub = DeleteFromSub(maet->ae_list[i].ind.key, msub);
    }
    return(msub);
}

static atomlist *InstantiateAtomList(al, sub)
atomlist *al;
subst_t *sub;
{
    atomlist *a;
    ae_term *aet;
    process_expr *pe;

    if (al == NULL)
        return(NULL);
    a = AllocAtom();
    *a = *al;
    if (a->atom->fun == AET) {
	aet = OpentermInstantiate(&a->atom->proc_expr.pe2, sub, Eqm);
/*
printf("***** ");
print_ae_term(&a->atom->proc_expr.pe2);
printf(" -->> ");
print_ae_term(aet);
printf("\n");
*/
	pe = PSF_MALLOC(process_expr);
	pe->fun = AET;
	pe->proc_expr.pe2 = *aet;
	a->atom = pe;
    }
    a->next = InstantiateAtomList(al->next, sub);
    return(a);
}

static int CmpIf(aet1, aet2)
struct ae_term *aet1;
struct ae_term *aet2;
{
    int i;
    int res;

    if (aet1->ind.table != aet2->ind.table)
        return (aet1->ind.table - aet2->ind.table);
    if (aet1->ind.key != aet2->ind.key)
        return (aet1->ind.key - aet2->ind.key);
    if (aet1->a != aet2->a)
        return (aet1->a - aet2->a);
    for (i = 0; i < aet1->a; i++) {
        res = CmpIf(&aet1->ae_list[i], &aet2->ae_list[i]);
        if (res)
            return (res);
    }
    return (0);
}

static int ContainsVar(aet)
ae_term *aet;
{
    int i;

    if (aet->ind.table == VAR)
	return(1);
    for (i = 0; i < aet->a; i++) {
	if (ContainsVar(&aet->ae_list[i]))
	    return(1);
    }
    return(0);
}

static ptree *Instantiate(pt, sub)
ptree *pt;
subst_t *sub;
{
    pedge *e, *eh;
    ae_term *aet1, *aet2;

    if (pt->id != NULL) {
	pt->id = OpentermInstantiate(pt->id, sub, Eqm);
/*
printf ("Id : ");
print_ae_term(pt->id);
printf ("\n");
*/
    }
    if (pt->fun == IF) {
	aet1 = OpentermInstantiate(&pt->pe->proc_expr.pe4.aex, sub, Eqm);
	aet2 = OpentermInstantiate(&pt->pe->proc_expr.pe4.aey, sub, Eqm);
	/* Er mogen nu geen variabelen meer in aet1 en aet2 staan */
	if ((! ContainsVar(aet1)) && (! ContainsVar(aet2))) {
	    if ( CmpIf(aet1, aet2)) {
/*
printf("if:: ");
print_ae_term(aet1);
printf (" != ");
print_ae_term(aet2);
printf ("\n");
*/
/*
		return(NULL);
*/
		pt->fun = '\\';
		pt->edge = NULL;
		return(pt);
	    }
/*
else {
printf("if:: ");
print_ae_term(aet1);
printf (" == ");
print_ae_term(aet2);
printf ("\n");
}
*/
	}
    }
    for (e = pt->edge, eh = pt->edge; e != NULL; e = e->next) {
	e->atom = InstantiateAtomList(e->atom, sub);
	e->node = Instantiate(e->node, sub);
	if (e->node == NULL) {
	    if (eh == pt->edge) {
		pt->edge = e->next;
		eh = pt->edge;
	    } else {
		eh->next = e->next;
	    }
	} else {
	    eh = e;
	}
    }
    if ((pt->edge == NULL) && pt->fun == ALT) {
	pt->fun = '\\';
    }
    return(pt);
}

static ptree *Expand(ptree *, plist *, subst_t *);

static ptree *ExpandMerge(pt, pl, sub)
ptree *pt;
plist *pl;
subst_t *sub;
{
    keytype key;
    char *f;
    s_term *st;
    ae_term *aet;
    subst_t *newsub;
    pedge *e1, *e2;
    ptree *mpt;
    int i;

    key = pt->pe->proc_expr.pe1.ind.key;
    if (Mod->var[key].ind.table == SET) {
	key = Mod->var[key].ind.key;
	if ((f = get_ff_field("enum", Mod->set[key].ff)) != NULL)
	    sscanf(f, "%d", &key);
    } else {
	key = Mod->var[key].ind.key;
	if ((f = get_ff_field("enum", Mod->sor[key].ff)) != NULL) {
	    sscanf(f, "%d", &key);
	} else {
	    fprintf(stderr, "Error: merge not over a set\n");
	    exit(1);
	}
    }
    st = &Mod->set[key].construct.set_term;
    if (st->fun != ENU) {
	fprintf(stderr, "Error: merge set is not an enumeration\n");
	exit(1);
    }
    mpt = pt->edge->node;
    e1 = NULL;
    for (i = st->a - 1; i >= 0; i --) {
        aet = term_reduce(Eqm, st->arr[i].ae_t);
        newsub = copy_add_to_sub(sub, &pt->pe->proc_expr.pe1.ind, aet, Eqm);
        ae_term_free(aet);
	e2 = AllocPedge();
	e2->node = CopyPtree(mpt);
	e2->node = Instantiate(e2->node, newsub);
	e2->node = Expand(e2->node, pl, newsub);
	e2->next = e1;
	e1 = e2;
    }
    pt->edge = e1;
    pt->fun = PAR;
    return(pt);
}

static ptree *Expand(pt, pl, sub)
ptree *pt;
plist *pl;
subst_t *sub;
{
    pedge *e;
    ae_term *aet;
    int pd;
    subst_t *msub;

    if (pt->edge == NULL) {
	if ((pt->fun != '\\') && (pt->fun != DLK)) {
	    aet = OpentermInstantiate(&pt->pe->proc_expr.pe2, sub, Eqm);
	    pd = MatchProcess(aet, &msub);
	    if (pd == 0) {
		fprintf(stderr, "Warning: Could not match '");
		set_print_output_file(stderr);
		print_process_expr(pt->pe);
		set_print_output_file(stdout);
		fprintf(stderr, "'\n");
	    } else {
		if (! InPlist(pt->pe->proc_expr.pe2.ind.key, pl)) {
		    pl = AddPlist(pt->pe->proc_expr.pe2.ind.key, pl);
		    /* filter msub */
		    msub = FilterSubs(pd, &pt->pe->proc_expr.pe2, sub, msub);
		    pt = CopyPtree(PT[pd]);
		    pt = Instantiate(pt, msub);
		    pt = Expand(pt, pl, msub);
		    pl = SubPlist(pl);
		}
	    }
	}
	return pt;
    }

    if (pt->fun == MRG) {
	pt = ExpandMerge(pt, pl, sub);
    } else {
	for (e = pt->edge; e != NULL; e = e->next) {
	    e->node = Expand(e->node, pl, sub);
	}
    }
    return pt;
}

ptree *ExpandPtree(pt)
ptree *pt;
{
    pt = Instantiate(pt, NULL);
    pt = Expand(pt, NULL, NULL);
    return pt;
}
