#include <stdio.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "ptree.h"
#include "partree.h"
#include "eqm.h"
#include "main.h"
#include "prtilparts.h"
#include "realproc.h"

typedef struct map {
    int old;
    int new;
    struct map *next;
} map;
static map *ML = NULL;

static void Map(o, n)
int o;
int n;
{
    map *h;

    h = PSF_MALLOC(map);
    if (ML == NULL) {
	h->next = NULL;
    } else {
	h->next = ML;
    }
    ML = h;
    h->old = o;
    h->new = n;
}

static int GetMap(d)
int d;
{
    map *h;

    for (h = ML; h != NULL; h = h->next) {
	if (h->old == d)
	    return(h->new);
    }
    return(d);
}

typedef struct plist {
    int nr;
    ptree *pt;
    struct plist *next;
} plist;

static plist *AddPlist(pl, pt)
plist *pl;
ptree *pt;
{
    plist *h;

    h = PSF_MALLOC(plist);
    h->nr = pt->id->ind.key;
    h->pt = pt;
    h->next = pl;
    return(h);
}

static plist *AddPlists(pl1, pl2)
plist *pl1;
plist *pl2;
{
    plist *h;

    if (pl1 == NULL)
	return(pl2);
    for (h = pl1; h->next != NULL; h = h->next);
    h->next = pl2;
    return(pl1);
}

static plist *CopyPlist(pl)
plist *pl;
{
    plist *h;

    if (pl == NULL)
	return(NULL);
    h = PSF_MALLOC(plist);
    h->nr = pl->nr;
    h->pt = pl->pt;
    h->next = CopyPlist(pl->next);
    return(h);
}

static plist *InPlist(pl, pt)
plist *pl;
ptree *pt;
{
    plist *h;

    for (h = pl; h != NULL; h = h->next) {
	if (h->nr == pt->id->ind.key)
	    return(h);
    }
    return(NULL);
}

static void MapDuplicate(o, d)
ptree *o;
ptree *d;
{
    pedge *oe, *de;

    if (d->pid != NULL) {
	if (Option_Debug)
	    printf("mapdup: %d -> %d\n", d->pid->id, o->pid->id);
	Map(d->pid->id, o->pid->id);
	d->pid->id = RealProcessId(o->pid->id);
    }
	
    for (oe = o->edge, de = d->edge; de != NULL && oe != NULL; oe = oe->next, de = de->next) {
	MapDuplicate(oe->node, de->node);
    }
}

static plist *RemoveDuplicates(pt, altpl)
ptree *pt;
plist *altpl;
{
    pedge *e;
    plist *pl, *newpl, *newaltpl;
    plist *o;

    if (Option_Debug) {
	if (pt->id != NULL) {
	    print_ae_term(pt->id);
	    if (pt->pid != NULL) {
		printf(" %d", pt->pid->id);
	    }
	    printf("\n");
	}
    }
    if (pt->id != NULL && pt->pid == NULL) {
	if (o = InPlist(altpl, pt)) {
	    /* remove */
	    if (Option_Debug)
		printf("remove %d\n", pt->id->ind.key);
	    MapDuplicate(o->pt, pt);
	    pt->id = NULL;
	    return(NULL);
	}
    }
    if (pt->fun == HID || pt->fun == ENC) {
	(void) RemoveDuplicates(pt->edge->node, NULL);
	pl = NULL;
    } else if (pt->fun == ALT) {
	pl = RemoveDuplicates(pt->edge->node, altpl);
	newaltpl = AddPlists(CopyPlist(pl), CopyPlist(altpl));
	newpl = RemoveDuplicates(pt->edge->next->node, newaltpl);
	pl = AddPlists(newpl, pl);
    } else {
	pl = NULL;
	for (e = pt->edge; e != NULL; e = e->next) {
	    newpl = RemoveDuplicates(e->node, altpl);
	    pl = AddPlists(newpl, pl);
	}
    }
    if (pt->id != NULL && pt->pid == NULL)
	pl = AddPlist(pl, pt);
    return(pl);
}

static int TermsEqual(h, a)
ae_term *h;
ae_term *a;
{
    int i;

    if ((h->ind.table == VAR) && (a->ind.table == VAR))
	return(1);
    if ((h->ind.table != a->ind.table) || (h->ind.key != a->ind.key))
	return(0);
    for (i = 0; i < h->a; i ++) {
	if (! TermsEqual(&h->ae_list[i], &a->ae_list[i]))
	    return(0);
    }
    return(1);
}

static int AtomsEqual(h, a)
process_expr *h;
process_expr *a;
{
    if (h->fun != a->fun)
	return(0);
    if (h->fun != AET)
	return(0); /* something that should not appear here */
    return(TermsEqual(&h->proc_expr.pe2, &a->proc_expr.pe2));
}

static int DuplicateAtom(a, al)
atomlist *a;
atomlist *al;
{
    atomlist *h;

    for (h = al; h != a; h = h->next) {
	if (h->props.pid->id == a->props.pid->id) {
	    if (AtomsEqual(h->atom, a->atom)) {
		if (Option_Debug) {
		    printf("dupatom: %d  ", h->props.pid->id);
		    print_process_expr(h->atom);
		    printf("\n");
		}
		return(1);
	    }
	}
    }
    return(0);
}

static int DuplicateCommunication(c, cl)
commlist *c;
commlist *cl;
{
    commlist *h;

    for (h = cl; h != c; h = h->next) {
	if ((h->p1->id == c->p1->id) && (h->p2->id == c->p2->id)) {
	    /* or the other way round and check directions */
	    if (TermsEqual(h->comm, c->comm)) {
		if (Option_Debug) {
		    printf("dupcomm: %d %d  ", h->p1->id, h->p2->id);
		    print_ae_term(h->comm);
		    printf("\n");
		}
		return(1);
	    }
	}
    }
    return(0);
}

static atomlist *RemoveDuplicateAtoms(al)
atomlist *al;
{
    atomlist *h, *prev;

    for (h = al; h != NULL; h = h->next) {
	h->props.pid->id = GetMap(h->props.pid->id);
    }
    prev = NULL;
    for (h = al; h != NULL; h = h->next) {
	if (DuplicateAtom(h, al)) {
	    if (prev == NULL) {
		al = h->next;
	    } else {
		prev->next = h->next;
	    }
	} else
	    prev = h;
    }
    return(al);
}

static commlist *RemoveDuplicateCommunications(cl)
commlist *cl;
{
    commlist *h, *prev;

    for (h = cl; h != NULL; h = h->next) {
	h->p1->id = GetMap(h->p1->id);
	h->p2->id = GetMap(h->p2->id);
    }
    prev = NULL;
    for (h = cl; h != NULL; h = h->next) {
	if (DuplicateCommunication(h, cl)) {
	    if (prev == NULL) {
		cl = h->next;
	    } else {
		prev->next = h->next;
	    }
	} else
	    prev = h;
    }
    return(cl);
}

void DuplicateProcesses(pt)
partree *pt;
{
    (void) RemoveDuplicates(pt->pt, NULL);
    pt->al = RemoveDuplicateAtoms(pt->al);
    pt->cl = RemoveDuplicateCommunications(pt->cl);
}
