#include <stdio.h>
#include "psf_prototype.h"
#include "datatypes.h"
#include "dlist.h"
#include "global.h"
#include "print.h"
#include "tree.h"
#include "treeprint.h"

/**********************************************************************\
   Print a list L of pointers to block.
\**********************************************************************/
void print_list(L)
    ListP L;
{
    int i = 0;
    elementP R;

    fprintf(fd_out, "{");
    for (R = DFirst(L); DValid(R); R = DNext(R)) {
	if (i++)
	    fprintf(fd_out, ", ");
	fprintf(fd_out, "B%d", BLOCKNUM(BLOCK((treeP) DATA(R))));
    }
    fprintf(fd_out, "}");
}				/* print_list */

/**********************************************************************\
   Print the block-tree using depth-first traversal.
\**********************************************************************/
void process_node(root)
    treeP root;
{
    char *a;

    fprintf(fd_out, "\n\nBlock B%d = ", BLOCKNUM(BLOCK(root)));
    list_states(fd_out, BLOCK(root));
    fprintf(fd_out, "\n");
    if (LEFT(root)) {
	a = SPLITLABEL(root);
	fprintf(fd_out, "label =\t\t\t%s\n", a);
	fprintf(fd_out, "Splitter =\t\tB%d\n", BLOCKNUM(SPLITTER(root)));
	fprintf(fd_out, "reachable(%s) = \t", STR_SKIP);
	print_list(ReachableTau(root));
	fprintf(fd_out, "\nreachable(%s) = \t\t", a);
	print_list(Reachable(root));
	fprintf(fd_out, "\n");
    }
}				/* process_node */

/**********************************************************************\
   Print the block-tree using depth-first traversal.
\**********************************************************************/
void df_treeprint(root)
    treeP root;
{
    if (root != NULL) {
	process_node(root);
	df_treeprint(LEFT(root));
	df_treeprint(RIGHT(root));
    }
}				/* df_treeprint */

/**********************************************************************\
   Print the block-tree using breadth-first traversal.
\**********************************************************************/
void bf_treeprint(root)
    treeP root;
{
    if (root != NULL) {
	bf_treeprint(LEFT(root));
	process_node(root);
	bf_treeprint(RIGHT(root));
    }
}				/* bf_treeprint */
