#include "psf_prototype.h"
#include "psf_malloc.h"
#include "datatypes.h"
#include "dlist.h"
#include "global.h"
#include "tree.h"

#define tree_alloc() (treeP) PSF_MALLOC(struct tree)

/**********************************************************************\
   allocate memory for a new node and initialize it.
\**********************************************************************/
treeP new_node()
{
    treeP ptr;

    ptr = tree_alloc();
    ptr->parent = NULL;
    ptr->left = NULL;
    ptr->right = NULL;
    ptr->block = NULL;
    ptr->level = 0;
    ptr->left_label_a = NULL;
    ptr->left_label_B = NULL;
    ptr->right_label_r1 = NULL;
    ptr->right_label_r2 = NULL;
    return (ptr);
}

/**********************************************************************\
   Create a new node for B2, and insert it as right-child of B.
\**********************************************************************/
void insert_right(B, B2)
    blockP B, B2;
{
    treeP parent = B->node, child = new_node();

    child = new_node();
    child->block = B2;
    child->level = parent->level + 1;
    child->parent = parent;
    parent->right = child;
    B2->node = child;
}				/* insert_right */

/**********************************************************************\
   Create a new node for B1, and insert it as left-child of B.
\**********************************************************************/
void insert_left(B, B1)
    blockP B, B1;
{
    treeP parent = B->node, child = new_node();

    child = new_node();
    child->block = B1;
    child->level = parent->level + 1;
    child->parent = parent;
    parent->left = child;
    B1->node = child;
}				/* insert_left */

/**********************************************************************\
   labels the arc to the leftchild of B with a and B1.
\**********************************************************************/
void LabelLeftArc(B, a, B1)
    blockP B, B1;
    char *a;
{
    treeP node = B->node;

    node->left_label_a = a;
    node->left_label_B = B1;
}				/* LabelLeftArc */

/**********************************************************************\
   labels the arc to the rightchild of B with R1 and R2.
\**********************************************************************/
void LabelRightArc(B, R1, R2)
    blockP B;
    ListP R1, R2;
{
    treeP node = B->node;

    node->right_label_r1 = R1;
    node->right_label_r2 = R2;
}				/* LabelRightArc */
