#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "datatypes.h"
#include "dlist.h"
#include "global.h"
#include "readgraph.h"
#include "reduce.h"

/**********************************************************************\
   Generate a new name by appending the character representation of
   n to the letter "B". Thus the new states have the same names as
   the blocks in the final partition.
\**********************************************************************/
char *NewName(n)
    int n;
{
    char *s, *num;

    num = itoa(n);
    s = PSF_NMALLOC(char, strlen(num)+2);
    s[0] = 'B';
    strcpy(s+1, num);
    PSF_FREE(num);
    return s;
}				/* NewName */

/**********************************************************************\
   Search the transition S1--LABEL(T)-->S2 in the sorted list of
   transitions LP. If it was not found, then it is added to LP.
\**********************************************************************/
void SearchTransition(LP, S1, S2, T)
    ListP LP;
    stateP S1, S2;
    transitionP T;
{
    transitionP tmp = DFirst(LP), prev = tmp, NewT;
    bool found = FALSE;
    int label;

    label = LABEL(T);
    while (DValid(tmp)) {
	if (LABEL(tmp) < label) {
	    prev = tmp;
	    tmp = DNext(tmp);
	} else {
	    found = TRUE;
	    break;
	}
    }				/* while wrong label */
    while (DValid(tmp) && found) {
	if (LABEL(tmp) == label) {
	    if (SOURCE(tmp) == S1 && TARGET(tmp) == S2) {
		found = FALSE;
		prev = NULL;
	    }
	    /* found the transition */
	    else {
		prev = tmp;
		tmp = DNext(tmp);
	    }			/* not found yet */
	}
	/* still the right label */
	else
	    found = FALSE;	/* wrong label */
    }				/* while searching */
    if (prev) {
	NewT = new_transition();
	SOURCE(NewT) = S1;
	TARGET(NewT) = S2;
	LABEL(NewT) = label;
	ACTUALLABEL(NewT) = ACTUALLABEL(T);
	if (prev == tmp)
	    DAddHead(LP, NewT);
	else if (found)
	    DAddTail(LP, NewT);
	else
	    DInsert(LP, prev, NewT);
    }				/* transition not already present */
}				/* SearchTransition */

/**********************************************************************\
   Return a pointer to the reduced automaton. The reduced automaton
   is the transition system derived from the final partition by
   making each block in the partition a new state, and adding as the
   transitions the non-inert transitions between the original states,
   avoiding duplicate transitions.
\**********************************************************************/
blockP ReducedAutomaton(P)
    ListP P;
{
    blockP B, NewB = new_block();
    transitionP T;
    stateP S1, S2;
    int name;

    BLOCKNUM(NewB) = NumberOfBlocks;
    for (B = DFirst(P); DValid(B); B = DNext(B)) {
	name = BLOCKNUM(B);
	S2 = AddState(NewB, name);
	if (ACTUALNAME(S2) == NULL)
	    ACTUALNAME(S2) = NewName(name);
	for (T = DFirst(NONINERT(B)); DValid(T); T = DNext(T)) {
	    name = BLOCKNUM(BLOCKREF(SOURCE(T)));
	    S1 = AddState(NewB, name);
	    if (ACTUALNAME(S1) == NULL)
		ACTUALNAME(S1) = NewName(name);
	    SearchTransition(NONINERT(NewB), S1, S2, T);
	}			/* for each non-inert transition */
    }				/* for all blocks */
    return (NewB);
}				/* ReducedAutomaton */
