.TH EQUIV L "16 December 1992"
.SH NAME
equiv - Branching Bisimulation equivalence tester
.SH SYNOPSIS
.B equiv
[
.B \-cdhirvxBFINTY
] [[
.B \-f
]
.IR filename [ .til ]
]
.if n .ti +10
[
.B \-o
.I outputfile
] [
.B \-M
.I maximum
] [
.B \-t
.I S1
.I S2
\&.\|.\|.
]
.SH DESCRIPTION
.LP
.B Equiv
computes Branching Bisimimulation equivalence on transition
systems and optionally generates Distinguishing Formulae.
.PP
.B Equiv
takes as input a TIL file
.I filename
which must contain a regular process specification, i.e. it contains only 
atoms, process variables and process definition; each process
definition must be of the form:
.sp
.in +1i
.I X
=
.IR a . Y
.in
.sp
If 
.B \-f
.I filename
is not used, then
.B equiv
reads from standard input.
The process specification defines a transition
system (i.e. a directed, labelled graph).  The process variables
represent the states of the transition system and the atoms represent
the labels on the transitions.  Each process specification
.sp
.in +1i
.I X
=
.IR a . Y
.in
.sp
represents a transition
.sp
.in +1i
.I X
.RI \-\h'-0.1m'\- a \-\h'-0.1m'\->
.I Y
.in
.sp
.PP
With no options, 
.B equiv
merely computes the final partition which corresponds with Branching
Bisimulation Equivalence.  This is only useful to measure
.BR equiv 's
speed.  To show the result, use the 
.B \-F
option.  If the
.B \-d
option is used, a so-called block-tree is generated.  This block tree is
needed for generating Distinguishing Formulae.  However,
.B \-d 
alone merely computes the block tree.  To show the outcome, use
.BR \-B .
With the
.B \-v
option, some additional information is printed on standard output.
Error messages are printed on standard error.  All other output goes
to the standard output, or to the file
.I outputfile
if specified with the
.B \-o
option.
.PP
The three main phases are:
.TP 4n
1.
Converting the input.
.br
During this phase,
.B equiv
converts the TIL module to the internal data structure and sorts the
states topographically.  Also, cycles of "skip"-transitions are deleted.
For this the well known method of Aho, Hopcroft & Ullman [AHU74] is used.
The result is called the initial partition; to display it, use the
.B \-I
option.
.TP
2.
Computing the final partition.
.br
When the input has been converted a partition refinement algorithm, 
based on Groote & Vaandrager [GV90] is executed.  It computes the final 
partition, which corresponds to the quotient of the input and 
Branching Bisimulation equivalence.  If the 
.B \-d 
option is used, then the block tree is constructed during this phase.
If the 
.B \-r
option is used, the Reduced Automaton is constructed.
The time and space complexity are both
.IR O ( m * n )
where
.I m
is the number of transitions and
.I n
is the number of states.
.TP
3.
Testing equivalence.
.br
When the final partition has been computed, the arguments 
.I S1, S2,
\&.\|.\|. of the
.B \-t
option (if any) can be tested for equivalence.  The maximum number of
arguments is 64, or 
.I maximum
if specified with the 
.B \-M
option.  Two states are
Branching Bisimulation equivalent (Branching Bisimilar) if they
are in the same block of the final partition.  If two states are
not Branching Bisimilar, and the 
.B \-d
option is used, a Distinguishing Formula (i.e. a formula explaining
the difference between the states) is output.  The method used here
is the one from H. Korver [Kor91].  If the 
.B \-i
option is used, some additional interactive equivalence testing
may be performed.
.SH OPTIONS
.TP 8n
.B \-c
Print the equivalence classes of the final partition.  Each equivalence
class is printed as
.br
.IR class1 : " element1 element2" " \&.\|.\|."
.br
.IR class2 : " element3 element4" " \&.\|.\|."
.br
\&.\|.\|.
.TP
.B \-d
Generate Distinguishing Formulae.
.TP
.BI \-f " filename"
.br
Use
.I filename
as the input-file.  The
.B \-f
is optional, and so is the
.I .til
extension.  If no input-file is specified,
.B equiv
reads its input from the standard input, and interactive
testing is disabled.
.TP
.B \-h
Print a list of available options.
.TP
.B \-i
After the partition refinement phase and the equivalence testing
phase (if the 
.B \-t
option was used), some additional interactive equivalence testing
may be performed.  However, this is disabled if
.B equiv
reads from standard input (see
.BR \-f ).
.TP
.BI \-o " outputfile"
.br
Use 
.I outputfile
as the output-file.  If no output-file is specified, the output goes
to the standard output.
.TP
.B \-r
Generate the Reduced Automaton.  Note: all transitions in the Reduced
Automaton are non-inert, which is not necessarily correct by
definition of non-inert (see [GV90]).  This feature was added to write the
Reduced Automaton on a TIL file, in which there is no difference between
inert and non-inert transitions.
.TP
.BI \-t " S1 S2 \&.\|.\|."
.br
Test equivalence for 
.I S1
and
.I S2
,
.I S3
and
.I S4
, \&.\|.\|.
.br
If the 
.B \-d
option is used, a Distinguishing Formula will be printed if two
states are not Branching Bisimilar.
.TP
.B \-v
Turn on verbose mode.  In verbose mode, some additional information,
like the current version number, date of last compilation,
number of states, number of transitions, number of blocks
and some messages concerning the current action are printed on the
standard output.  This may be useful if the input-file is very large
and
.B equiv
is quiet for a long time.
.TP
.B \-x
Print blocks (equivalence classes) in a more informative way.  In this
mode each block is printed as a set of non-bottom states and their
outgoing inert transitions, a set of bottom-states, and a set of
transitions ending in the block.
This is not very useful for the average user.
Note:
.B \-x
does not affect
.BR \-c .
.TP
.B \-B
Print the block tree.  The output does not seem very comprehensive.
.TP
.B \-F
Print the final partition.  The final partition is printed as a set of
subsets of states, each subset being an equivalence class.  This is much
like the 
.B \-c
option.  If the
.B \-x
option is used, a different style is used (see 
.BR \-x ).
.TP
.B \-I
Print the initial partition.  See 
.BR \-F .
.TP
.B \-M
.I maximum
.br
Set the maximum number of states to test with the 
.B \-t
option to 
.IR maximum .
The
.I maximum
must be a non-negative integer number.
.TP
.B \-T
Print transitions when reading input.  Each transition is printed as
.sp
.in +1i
.I X
.RI \-\h'-0.1m'\- a \-\h'-0.1m'\->
.I Y
.in
.sp
where
.I X
and
.I Y
are states and
.I a
is an atomic action.
.TP
.B \-Y
Issue symmetrical Distinguishing Formulae, i.e.
.RI DF( S1 , S2 )
=
.RI DF( S2 , S1 )
for all
.IR S1 ,
.IR S2 ).
This saves 
.RI O( n )
space during the construction of the block-tree, where
.I n
is the number of states in the initial partition.
.SH DIAGNOSTICS
Diagnostics are meant to be self-explanatory. 
.TP
.B "equiv: out of memory"
Not enough swap space was available.  Try the
.B \-Y
option.
.TP
.BI "equiv: can't open " filename ": " resaon
The named file could not be opened for the stated reason.
.TP
.B equiv: too many states.
The number of states entered on the command line exceeded 64 or
the number specified with the 
.B \-M 
.I maximum
option.
.TP
.B "equiv: this TIL module is not regular."
A process definition that doesn't have the
.I X
=
.IR a . Y
form was encountered.
.TP
.BI "equiv: illegal value " number
The 
.I maximum
number must be a non-negative integer.
.SH EXIT STATUS
.TP 4n
0
Successful execution.
.TP
1
An error occurred.
.SH EXAMPLES
Some typical examples are:
.PP
equiv -d filename -t S1 S2
.PP
equiv -di filename
.SH SEE ALSO
.BR psf (1),
.BR til_psf (1).
.SH REFERENCES
.TP 10n
[AHU74]
A.V. Aho, J.E. Hopcroft & J.D. Ullman (1974):
.IR "The design and analysis of computer algorithms" ,
Addison-Wesley.
.TP
[GV90]
J.F. Groote & F.W. Vaandrager:
.I
An efficient algorithm for branching bisimulation and stuttering
.IR equivalence ,
in:
.I Proceedings
17th ICALP, Warwick,
(M.S. Paterson, ed.) LNCS 443, pages 626-638, Springer Verlag, 1990.
.TP
[Kor91]
H.P. Korver:
.IR "Computing distinguishing formulae for branching bisimulation" ,
Report P9103, Programming Research Group, University of Amsterdam, 1991.
.SH AUTHOR
.LP
Edward Polak <polak@fwi.uva.nl>
