/************************************************************************

Header : dlist.h
Purpose: Generic list module. Struct DData must be first field of
	 record to be linked or put the contents of DData as the first field.
	 In the latter case they could be accessed directly.
	 Records will be doubly linked.
Changed:
  190791:
    Added DLength()
  101091:
    Added Dfirst(L), DNext(D), DValid(D)

*************************************************************************/
#include "psf_malloc.h"
#include "psf_standards.h"

#ifndef _DLIST_
#define _DLIST_ 1

typedef struct DData *DDataP;

#ifndef _SLIST_
typedef struct List *ListP;
#endif

typedef struct DData {
    DDataP Next;
    DDataP Prev;
} DData;

#ifndef _SLIST_
typedef struct List {
    void *Head;			/* DataP Head, Tail, TailPred */
    void *Tail;
    void *TailPred;
    int Length;
} List;
#endif

/* dlist.c */
extern int DLength PROTO_ARGS((ListP L));
extern int DEmptyList PROTO_ARGS((ListP L));
extern void DNewList PROTO_ARGS((ListP L));
extern void DAddHead PROTO_ARGS((ListP L, void *D));
extern void DAddTail PROTO_ARGS((ListP L, void *D));
extern void DAppend PROTO_ARGS((ListP L, ListP R));
extern void delete PROTO_ARGS((void *D));
extern void DInsert PROTO_ARGS((ListP L, void *D1, void *D2));
extern void DDelete PROTO_ARGS((ListP L, void *D));
extern void DFreeData PROTO_ARGS((ListP L));

/* Pre: DValid(D). */
#define DNext(D)  (void *) (((DDataP) D)->Next)
#define DValid(D) ((bool) ((DDataP) D)->Next)
#define DFirst(L) ((void *) (L)->Head)
#define list_alloc() (ListP) PSF_MALLOC(struct List)
#endif
