/*
 * File: dlist.c
 * Purpose: Functions for double linked list
 * Changed:
 */

#include <stdlib.h>
#include "psf_prototype.h"
#include "dlist.h"

int DLength(L)
    ListP L;
{
    return L->Length;
}				/* DLength */

int DEmptyList(L)
    ListP L;
{
    return ((DDataP) L->Head)->Next == NULL;
}				/* DEmptyList */

void DNewList(L)
    ListP L;
{
    L->Head = &L->Tail;
    L->Tail = NULL;
    L->TailPred = &L->Head;
    L->Length = 0;
}				/* DNewList */

void DAddHead(L, D)
    ListP L;
    void *D;
{
    ((DDataP) D)->Next = L->Head;
    ((DDataP) L->Head)->Prev = D;
    ((DDataP) D)->Prev = (DDataP) & L->Head;
    L->Head = D;
    L->Length++;
}				/* DAddHead */

void DAddTail(L, D)
    ListP L;
    void *D;
{
    ((DDataP) L->TailPred)->Next = D;
    ((DDataP) D)->Prev = L->TailPred;
    L->TailPred = D;
    ((DDataP) D)->Next = (DDataP) & L->Tail;
    L->Length++;
}				/* DAddTail */

void DAppend(L, R)
/**********************************************************************\
   appends list R to list L
\**********************************************************************/
    ListP L, R;
{
    ((DDataP) L->TailPred)->Next = R->Head;
    ((DDataP) R->Head)->Prev = L->TailPred;
    L->TailPred = R->TailPred;
    ((DDataP) R->TailPred)->Next = (DDataP) & L->Tail;
    L->Length += R->Length;
}

void delete(D)
/**********************************************************************\
   deletes the element D from the list it occurs in
   bug: length of the list is not updated
\**********************************************************************/
    void *D;
{
    ((DDataP) D)->Next->Prev = ((DDataP) D)->Prev;
    ((DDataP) D)->Prev->Next = ((DDataP) D)->Next;
}

/* Inserts D2 in L just after D1 */
void DInsert(L, D1, D2)
    ListP L;
    void *D1, *D2;
{
    ((DDataP) D2)->Next = ((DDataP) D1)->Next;
    ((DDataP) D1)->Next->Prev = D2;
    ((DDataP) D1)->Next = D2;
    ((DDataP) D2)->Prev = D1;
    L->Length++;
}				/* DInsert */

/*
 * Delete D from L. D->Next must be valid.
 */
void DDelete(L, D)
    ListP L;
    void *D;
{
    ((DDataP) D)->Prev->Next = ((DDataP) D)->Next;
    ((DDataP) D)->Next->Prev = ((DDataP) D)->Prev;
    ((DDataP) D)->Next = NULL;
    ((DDataP) D)->Prev = NULL;
    L->Length--;
}				/* DDelete */

void DFreeData(L)
    ListP L;
{
    DDataP DelData, NextData;

    for (DelData=L->Head; NextData=DelData->Next, DelData; DelData=NextData)
	PSF_FREE(DelData);

    L->Head = &L->Tail;
    L->TailPred = &L->Head;
    L->Length = 0;
}				/* DFreeData */
