#ifndef DATATYPES
#define DATATYPES	1

#include "dlist.h"		/* to define ListP */

/* possible values of the .flag member of a struct state_data */
#define CLEAR	0
#define MARK	1
#define BOT     2
#define NON     3
#define ONSTACK 4

typedef struct state *stateP;
typedef struct state_data *state_ptr;
typedef struct transition *transitionP;
typedef struct block *blockP;
typedef struct element *elementP;

struct state {
    stateP Next, Prev;		/* Chaining pointers */
    state_ptr state;		/* pointer to contents */
};

struct state_data {
    int label;			/* unique number representing the name */
    char *act_label;		/* the actual name of the state */
    blockP block;		/* pointer to the block of which it is an
				 * element */
    ListP inert;		/* pointer to a list of inert transitions
				 * starting in this state */
    int flag;			/* indicating whether or not this state has
				 * been visited */
    int dfnumber,		/* for depth-first seach purposes */
    lowlink;			/* for depth-first seach purposes */
};

struct transition {
    transitionP Next, Prev;	/* Chaining pointers */
    int label;			/* unique number representing the label */
    char *act_label;		/* the actual label of the transition */
    stateP source,		/* pointer to its starting state */
    target;			/* pointer to its target state */
};

struct block {
    blockP Next, Prev;		/* Chaining pointers */
    ListP bottom,		/* pointer to a list of bottom states */
    non_bottom;			/* pointer to a list of non-bottom states in
				 * this block */
    ListP non_inert;		/* pointer to a list of the non-inert
				 * transitions that end in this block */
    int flag;			/* indicating whether or not the block has been
				 * visited */
    int label;			/* unique block-number */
    struct tree *node;		/* which node of the blocktree */
};

struct element {
    elementP Next, Prev;	/* Chaining pointers */
    void *data;			/* pointer to data */
};

/* datatypes.c */
extern stateP new_state PROTO_ARGS((void));
extern transitionP new_transition PROTO_ARGS((void));
extern blockP new_block PROTO_ARGS((void));
extern void AddPointer PROTO_ARGS((ListP BL, void *D));
extern void *DeletePointer PROTO_ARGS((ListP BL, elementP ptr));
extern stateP match_state PROTO_ARGS((ListP LP, int a));
extern stateP match_by_name PROTO_ARGS((ListP LP, char *a));
extern blockP fresh_block_copy PROTO_ARGS((blockP p));
extern stateP fresh_state_copy PROTO_ARGS((stateP p));
extern ListP copy_states PROTO_ARGS((ListP source));
extern bool identical PROTO_ARGS((char *name1, char *name2));
extern char *itoa PROTO_ARGS((int n));

#define STATE(SP)	((SP)->state)
#define NAME(SP)	((SP)->state->label)
#define ACTUALNAME(SP)	((SP)->state->act_label)
#define BLOCKREF(SP)	((SP)->state->block)
#define INERT(SP)	((SP)->state->inert)
#define FLAG(SP)	((SP)->state->flag)
#define DFNUMBER(SP)	((SP)->state->dfnumber)
#define LOWLINK(SP)	((SP)->state->lowlink)

#define LABEL(TP)	((TP)->label)
#define ACTUALLABEL(TP)	((TP)->act_label)
#define SOURCE(TP)	((TP)->source)
#define TARGET(TP)	((TP)->target)

#define BOTTOM(BP)	((BP)->bottom)
#define NONBOTTOM(BP)	((BP)->non_bottom)
#define NONINERT(BP)	((BP)->non_inert)
#define IN_BL(BP)	((BP)->flag)
#define NODE(BP)	((BP)->node)
#define BLOCKNUM(BP)	((BP)->label)

#define DATA(E)		((E)->data)

#define STR_SKIP	"skip"

#endif	/* DATATYPES */
