#include "psf_prototype.h"
#include "datatypes.h"
#include "dlist.h"
#include "formula.h"
#include "global.h"

static blockP lookup_state(P, s)
    ListP P;
    char *s;
{
    blockP B;

    for (B = DFirst(P); DValid(B); B = DNext(B))
	  if (match_by_name(NONBOTTOM(B), s) || match_by_name(BOTTOM(B), s))
	      return B;
    return NULL;
}				/* lookup_state */

void TestEquivalence(P, s1, s2)
    ListP P;
    char *s1, *s2;
{
    blockP B1, B2;

    if (!(B1 = lookup_state(P, s1)))
	fprintf(fd_out, "%s is not a state\n", s1);
    if (!(B2 = lookup_state(P, s2)))
	fprintf(fd_out, "%s is not a state\n", s2);

    if (B1 && B2) {
	if (BLOCKNUMBERS) {
	    fprintf(fd_out, "state %s is in block B%d\n", s1, BLOCKNUM(B1));
	    fprintf(fd_out, "state %s is in block B%d\n", s2, BLOCKNUM(B2));
	}
	if (B1 == B2)
	    fprintf(fd_out, "%s and %s are branching bisimilar\n", s1, s2);
	else {
	    fprintf(fd_out, "%s and %s are NOT branching bisimilar\n", s1, s2);
	    if (DISTFORM) {
		fprintf(fd_out, "Distinguishing Formula:\n");
		PrintFormula(NODE(B1), NODE(B2));
		fprintf(fd_out, "\n");
	    }			/* print distinguishing formula as well */
	}			/* not bisimilar */
    }				/* if both found */
}				/* TestEquivalence */
