#ifndef TYPEDEF_H
#define TYPEDEF_H
#include "psf_standards.h"
#include "ident.h"
#define TIL 0
#define DOT 1
typedef struct transition {
    struct state *s;
    ident a;
    struct state *t;
    struct transition *next;
    struct transition *fnext;
    ident so;			/* original names, renamed skip transitions */
    ident to;
} transition;

typedef struct state_set {
    int n;
    int m;
    struct state **s;		/* array of pointers to states */
} state_set;

typedef struct block_set {
    int n;
    struct block **b;		/* array of pointers to blocks */
} block_set;

#define FLAG flag
#define COLOR flag
typedef struct state {
    struct block *b;
    state_set fit;
    int flag;
    struct state *ren;
    struct state *next;
    ident name;
    bool created;
    bool hst; /* has skiptransition needed for rootedness */
} state;

typedef struct block {
    struct state *bs;
    struct state *nbs;
    struct block *nb;		/* next block in list */
    struct block *pb;		/* previous block in list */
    struct block *lc;		/* left child, can do sa into sb */
    struct block *rc;		/* right child, cannot  do sa into sb */
    int in;			/* nr of actions by which states enter block */
    transition **it;		/* array to lists of incoming transitions with
					 same  action */
    transition *is;		/* inert skip transitions */
    transition *nis;		/* non-inert incoming skip transitions */
    bool flag;
    int name;
				/* following are needed for creating hmlu
				 *  formulas */
    struct block *sb;		/* splitter block */
    ident sa;			/* splitter action */
    int hight;			/* distance through parent refs to initial
				 * block */
    struct block *p;		/* parent, which is split into this and other
				 * block */
    block_set r1;		/* r^P_skip(rc) */
    block_set r2;		/* r_alpha(rc) */
    bool rflag;
    int on;			/* nr outgoing */
    transition **ot;		/* outgoing transtions */
} block;

/* typedef.c */
extern transition **new_ta PROTO_ARGS((int n));
extern block *new_block PROTO_ARGS((void));
extern state *new_state PROTO_ARGS((void));
extern block **block_array PROTO_ARGS((int n));
extern state *get_state_by_name PROTO_ARGS((register ident name, register state_set *ss));
extern void put_state PROTO_ARGS((register state *s, register state_set *ss));
extern void print_state PROTO_ARGS((state *s));
extern void print_state_set PROTO_ARGS((state **s, int n));
extern void print_block PROTO_ARGS((block *b));
extern void print_block_list PROTO_ARGS((block *b));
extern void print_block_list_names PROTO_ARGS((block *b));

#endif				/* TYPEDEF_H */
