#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_standards.h"
#include "psf_malloc.h"

#include "typedef.h"
#include "ident.h"

transition **it;
int lastit;		/* set in main.c */
int nrit;		/* set in main.c */

transition **new_ta(n)
    int n;
{
    register transition **r;

    if (n + nrit >= lastit) {
	it = PSF_NMALLOC(transition *, lastit);
	nrit = 0;
    }
    r = &(it[nrit]);
    nrit += n;
    return r;
}


int nr_blocks = 0;
static block *blocks;
int nrblocks;			/* set in main.c */
int lastblock;			/* set in main.c */
block *new_block()
{
    register block *b;

    if (nrblocks >= lastblock) {
	nrblocks = 0;
	blocks = PSF_NMALLOC(block, lastblock);
    }
    b = &(blocks[nrblocks++]);
    b->lc = b->rc = (block *) NULL;
    b->is = b->nis = (transition *) NULL;
    b->flag = FALSE;
    b->rflag = FALSE;
    b->name = nr_blocks++;
    return b;
}

#define STATE_NR 100
static int nrstate = STATE_NR;
static int laststate = STATE_NR;
static state *states;

state *new_state()
{
    register state *s;

    if (nrstate >= laststate) {
	laststate *= 2;
	states = PSF_NMALLOC(state, laststate);
	nrstate = 0;
    }
    s = &states[nrstate++];
    s->fit.n = s->fit.m = s->flag = 0;
    s->ren = (state *) NULL;
    s->created = FALSE;
    s->hst = FALSE;
    return s;
}

int ba_m;			/* initialized in main.c */
int ba_n;
static block **ba;
block **block_array(n)
    int n;
{
    register block **b;

    if (ba_n + n >= ba_m) {
	ba = PSF_NMALLOC(block *, ba_m);
	ba_n = 0;
    }
    b = &(ba[n]);
    ba_n += n;
    return b;
}

state *get_state_by_name(name, ss)
    register ident name;
    register state_set *ss;
{
    register int i, j, k, es;
    register state **st;
    st=ss->s;
    if (ss->n == 0)
	return (state *) NULL;

    i = 0;
    j = ss->n - 1;
    do {
	k = (i + j) / 2;
	if ((es = st[k]->name - name) == 0)
	    return st[k];
	if (i == k) {
	    if (es < 0 || i == j)
		return (state *) NULL;
	    else {
		if (st[j]->name == name)
		    return st[j];
		else
		    return (state *) NULL;
	    }
	}
	if (es > 0)
	    i = k;
	else
	    j = k;

    }
    while (TRUE);
/*
    return st[k];
*/
}

void put_state(s, ss)
    register state *s;
    register state_set *ss;
{
    register int i, j, k, es;
    register state **ts;

    /* ss->s should be large enough */
    ts = ss->s;
    if (ss->n) {
	i = 0;
	j = ss->n - 1;
	do {
	    k = (i + j) / 2;
	    if ((es = ts[k]->name - s->name) == 0)
		break;
	    if (i == k) {
		if (es > 0) {
		    k = j;
		    if (ts[j]->name > s->name)
			k++;
		}
		break;
	    }
	    if (es > 0)
		i = k;
	    else
		j = k;
	}
	while (TRUE);
	if (k < ss->n && ts[k]->name == s->name)
	    return;
    } else
	k = 0;
    for (i = ss->n; i > k; i--)
	ts[i] = ts[i - 1];
    ss->n++;
    ts[k] = s;
}

void print_state(s)
    state *s;
{
    int i;

    (void) fprintf(stdout, "State %s\n", s->name);
    (void) fprintf(stdout, "Fit:\n");
    for (i = 0; i < s->fit.n; i++)
	(void) fprintf(stdout, "\t%s --skip-> %s\n",
		       s->name, s->fit.s[i]->name);

}

void print_state_set(s, n)
    state **s;
    int n;
{
    int i;
    state *t;

    for (i = 0; i < n; i++) {
	if (t = s[i]->ren)
	    while (t->ren)
		t = t->ren;
	if (t)
	    (void) fprintf(stdout, "%s -> %s",
			   s[i]->name, t->name);
	else
	    (void) fprintf(stdout, "%s", s[i]->name);
	if (i < n - 1)
	    fprintf(stdout, ", ");
	else
	    fprintf(stdout, "\n");
    }
}

void print_block(b)
    block *b;
{
    int i;
    transition *t;
    state *s;

    (void) fprintf(stdout, "\nBlock %i\n", b->name);
    if (!b->lc || !b->rc) {
	(void) fprintf(stdout, "\n\tbottom states:\n\t\t");
	s = b->bs;
	while (s) {
	    (void) fprintf(stdout, "%s", s->name);
	    if (s->next)
		(void) fprintf(stdout, ", ");
	    else
		(void) fprintf(stdout, "\n");
	    s = s->next;
	}

	(void) fprintf(stdout, "\n\tnon bottom states:\n\t\t");
	s = b->nbs;
	while (s) {
	    (void) fprintf(stdout, "%s", s->name);
	    if (s->next)
		(void) fprintf(stdout, ", ");
	    else
		(void) fprintf(stdout, "\n");
	    s = s->next;
	}

	(void) fprintf(stdout, "\n\tIncoming transitions:\n");

	for (i = 0; i < b->in; i++) {
	    (void) fprintf(stdout, "\t    action %s\n", b->it[i]->a);
	    t = b->it[i];
	    while (t) {
		(void) fprintf(stdout, "\t\t%s --%s-> %s\n",
			       t->s->name,
			       t->a,
			       t->t->name);
		t = t->next;
	    }
	}
	(void) fprintf(stdout, "\n\tIncoming non-inert skip transitions :\n");
	t = b->nis;
	while (t) {
	    (void) fprintf(stdout, "\t\t%s --skip-> %s\n",
			   t->s->name, t->t->name);
	    t = t->next;
	}
	(void) fprintf(stdout, "\n\tInert skip transitions :\n");
	t = b->is;
	while (t) {
	    (void) fprintf(stdout, "\t\t%s --skip-> %s\n",
			   t->s->name, t->t->name);
	    t = t->next;
	}
	(void) fprintf(stdout, "\n\tOutgoing transitions:\n");
	for (i = 0; i < b->on; i++) {
	    (void) fprintf(stdout, "\t    action %s\n", b->ot[i]->a);
	    t = b->ot[i];
	    while (t) {
		(void) fprintf(stdout, "\t\t%s --%s-> %s\n",
			       t->s->name,
			       t->a,
			       t->t->name);
		t = t->next;
	    }
	}
    } else {
	(void) fprintf(stdout, "sa: %s, sb: %i\n", b->sa, b->sb->name);
	(void) fprintf(stdout, "r1: ");
	for (i = 0; i < b->r1.n; i++)
	    (void) fprintf(stdout, "%i%s", b->r1.b[i]->name,
			   (i == b->r1.n - 1) ? "" : ", ");
	(void) fprintf(stdout, "\n");
	(void) fprintf(stdout, "r2: ");
	for (i = 0; i < b->r2.n; i++)
	    (void) fprintf(stdout, "%i%s", b->r2.b[i]->name,
			   (i == b->r2.n - 1) ? "" : ", ");
	(void) fprintf(stdout, "\n");
    }
    (void) fprintf(stdout, "\n");
}

void print_block_list(b)
    block *b;
{
    block *a;

    for (a = b; a; a = a->nb)
	print_block(a);
}

void print_block_list_names(b)
    block *b;
{
    block *a;

    for (a = b; a; a = a->nb)
	if (a->nb)
	    (void) fprintf(stdout, "Block %i, ", a->name);
	else
	    (void) fprintf(stdout, "Block %i", a->name);
    (void) fprintf(stdout, "\n");
}
