#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "env_variables.h"
#include "psf_malloc.h"

#include "ident.h"
#include "typedef.h"
#include "globals.h"

extern int nr_blocks;
extern block **the_blocks;
extern int graph_nr;

void show_til_final()
{
    register int i, j, k;
    register block *b;
    register transition *t;
    bool new;
    register state *s;
    ident *actions;
    register ident tmp;
    int nr_act, nr_procs;

    (void) fprintf(stdout, "[0.1]	{ <generated>%s }\n", progname);
    (void) fprintf(stdout, "[0.2]	{ <input>%s }\n", filename);
    actions = PSF_NMALLOC(ident, nr_trans);
    for (i = 0; i < nr_trans; i++)
	actions[i] = trans[i].a;
    for (i = 0; i < nr_trans; i++)
	for (j = i + 1; j < nr_trans; j++)
	    if (actions[i] < actions[j]) {
		tmp = actions[i];
		actions[i] = actions[j];
		actions[j] = tmp;
	    }
    for (i = nr_act = 0; i < nr_trans; i++)
	if (actions[i] != actions[i + 1] && actions[i] != skip)
	    actions[nr_act++] = actions[i];
    for (i = 0; i < nr_act; i++)/* i+1 not 0 is skip */
	(void) fprintf(stdout, "[3.%i] 0 { <n>%s }\n", i + 1, actions[i]);
    for (i = 0; i < nr_blocks; i++)
	if (the_blocks[i]) {
	    if (LONG_NAMES)
		(void) fprintf(stdout, "[4.%i] 0 { <n>(", i);
	    else
		(void) fprintf(stdout, "[4.%i] 0 { <n>%i <states>", i, i);
	    s = the_blocks[i]->bs;
	    while (s) {
		(void) fprintf(stdout, "%s", s->name);
		if (s->ren)
		    (void) fprintf(stdout, "(%s)", s->ren->name);
		if (s->next)
		    (void) fprintf(stdout, ", ");
		s = s->next;
	    }
	    if (the_blocks[i]->bs && the_blocks[i]->nbs)
		(void) fprintf(stdout, ", ");
	    s = the_blocks[i]->nbs;
	    while (s) {
		(void) fprintf(stdout, "%s", s->name);
		if (s->ren)
		    (void) fprintf(stdout, "(%s)", s->ren->name);
		if (s->next)
		    (void) fprintf(stdout, ", ");
		s = s->next;
	    }
	    if (LONG_NAMES)
		(void) fprintf(stdout, ")");
	    (void) fprintf(stdout, "}\n");
	}
    nr_procs = 1;
    for (i = 0; i < nr_blocks; i++)
	if (b = the_blocks[i]) {
	    for (j = 0; j < b->on; j++) {
		t = b->ot[j];
		new = TRUE;
		while (t) {
		    if (new) {
			/* retrieve number of action */
			for (k = 0; k < nr_act; k++)
			    if (actions[k] == t->a)
				break;
			if (k == nr_act) {
			    /* skip */
			    (void) fprintf(stdout,
				    "[9.%i] [4.%i] = <seq,2>(<skip> [4.%i]) ",
				    nr_procs++, t->s->b->name, t->t->b->name);
			} else {
			    k++;/* not 0 */
			    (void) fprintf(stdout,
				    "[9.%i] [4.%i] = <seq,2>([3.%i] [4.%i]) ",
				 nr_procs++, t->s->b->name, k, t->t->b->name);
			}
			(void) fprintf(stdout,
				   "{ <o>1 <trans>Block_%i--%s->Block_%i }\n",
				       t->s->b->name, t->a, t->t->b->name);
			break;
		    }
		    new = (t->next &&
			   (t->a != t->next->a || t->t->b != t->next->t->b));
		    t = t->next;
		}
	    }
	}
}



static void show_til_start_parts(nrs)
    int *nrs;
{

    register int i, j;
    ident *actions;
    register ident tmp;
    int nr_act;

    (void) fprintf(stdout, "[0.1]   { <generated>%s }\n", progname);
    (void) fprintf(stdout, "[0.2]   { <input>%s }\n", filename);
    actions = PSF_NMALLOC(ident, nr_trans);
    nr_act = 0;
    for (i = 0; i < nr_trans; i++)
	if (nrs[trans[i].s->flag])
	    actions[nr_act++] = trans[i].a;
    for (i = 0; i < nr_act; i++)
	for (j = i + 1; j < nr_act; j++)
	    if (actions[i] < actions[j]) {
		tmp = actions[i];
		actions[i] = actions[j];
		actions[j] = tmp;
	    }
    j = nr_act;
    for (i = nr_act = 0; i < j; i++)
	if (actions[i] != actions[i + 1] && actions[i] != skip)
	    actions[nr_act++] = actions[i];
    for (i = 0; i < nr_act; i++)/* i+1 not 0 is skip */
	(void) fprintf(stdout, "[3.%i] 0 { <n>%s }\n", i + 1, actions[i]);
    for (i = 0; i < ss.n; i++)
	if (nrs[ss.s[i]->flag]) {
	    (void) fprintf(stdout, "[4.%i] 0 { <n>%s }\n",
			   i + 1, ss.s[i]->name);
	    ss.s[i]->flag = i + 1;
	} else
	    ss.s[i]->flag = 0;
    for (i = 0; i < nr_trans; i++)
	if (trans[i].s->flag) {
	    for (j = 0; j < nr_act; j++)
		if (actions[j] == trans[i].a)
		    break;
	    if (j == nr_act)
		(void) fprintf(stdout,
			  "[9.%i] [4.%i] = <seq,2>(<skip> [4.%i]) { <o>1 }\n",
			       i, trans[i].s->flag, trans[i].t->flag);
	    else
		(void) fprintf(stdout,
			  "[9.%i] [4.%i] = <seq,2>([3.%i] [4.%i]) { <o>1 }\n",
			       i, trans[i].s->flag, j + 1, trans[i].t->flag);
	}
}

void show_til(nrs)
    int *nrs;
{
    if (nrs)
	show_til_start_parts(nrs);
    else
	show_til_final();
}
