#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "env_variables.h"
#include "psf_malloc.h"

#include "ident.h"
#include "typedef.h"
#include "globals.h"
#include "results_hmlu.h"


block *lca(s, t)		/* afterwards lca->flag= (s == rightchild) */
    block *s, *t;
{
    block *p, *q;
    bool pr;

    PSF_ASSERT(s->hight > 0);
    PSF_ASSERT(t->hight > 0);
    PSF_ASSERT(s != t);
    /* Need an anchester of both */
    p = s;
    q = t;
    pr = (p->p->rc == p);
    do {
	if (p->hight >= q->hight) {
	    pr = (p->p->rc == p);
	    p = p->p;
	} else {
	    q = q->p;
	}
    } while (p != q);
    p->flag = pr;
    return p;
}


void pb(b)
    block *b;
{
    int i;

    (void) fprintf(stdout, "Block %i\n", b->name);
    if (!b->rc || !b->lc)
	return;
    (void) fprintf(stdout, "sa: %s, sb: %i\n", b->sa, b->sb->name);
    (void) fprintf(stdout, "r1: ");
    if (b->r1.n)
	for (i = 0; i < b->r1.n; i++)
	    (void) fprintf(stdout, "%i%s", b->r1.b[i]->name,
			   ((i == b->r1.n - 1) ? "\n" : ", "));
    else
	(void) fprintf(stdout, "empty\n");
    (void) fprintf(stdout, "r2: ");
    if (b->r2.n)
	for (i = 0; i < b->r2.n; i++)
	    (void) fprintf(stdout, "%i%s", b->r2.b[i]->name,
			   ((i == b->r2.n - 1) ? "\n" : ", "));
    else
	(void) fprintf(stdout, "empty\n");
}

char *Delta(b1, b2)
    block *b1, *b2;
{
    block *p;
    register char *phi, *phi1, *phi2, *phi3, *tmp;
    register int i;

#ifdef HMLU_DEBUG
    (void) fprintf(stdout, "Start computing Delta(%i,%i)\n",
		   b1->name, b2->name);
#endif

    p = lca(b1, b2);

#ifdef HMLU_DEBUG
    pb(p);
#endif

    if (p->r1.n == 0)
	phi1 = "tt";
    else {
	phi1 = Delta(p, p->r1.b[0]);
	for (i = 1; i < p->r1.n; i++) {
	    tmp = Delta(p, p->r1.b[i]);
	    phi1 = PSF_REALLOC(phi1, char, strlen(phi1) + strlen(tmp) + 5);
	    (void) sprintf(phi1, "%s && %s", phi1, tmp);
	    PSF_FREE(tmp);
	}
    }
    if (p->r2.n == 0)
	phi2 = "tt";
    else {
	phi2 = Delta(p->sb, p->r2.b[0]);
	for (i = 1; i < p->r2.n; i++) {
	    tmp = Delta(p->sb, p->r2.b[i]);
	    phi2 = PSF_REALLOC(phi2, char, strlen(phi2) + strlen(tmp) + 5);
	    (void) sprintf(phi2, "%s && %s", phi2, tmp);
	    PSF_FREE(tmp);
	}
    }
    if (p->sa != skip) {
	phi = PSF_NMALLOC(char,
			  strlen(phi1) + strlen(phi2) + strlen(p->sa) + 7);
	(void) sprintf(phi, "(%s)<%s>(%s)", phi1, p->sa, phi2);
    } else {
	phi3 = Delta(p->sb, p->rc);
	phi = PSF_NMALLOC(char,
	       strlen(phi1) + strlen(phi2) + strlen(skip) + strlen(phi3) + 9);
	(void) sprintf(phi, "(%s)<%s>(%s && %s)", phi1, skip, phi2, phi3);
	PSF_FREE(phi3);
    }
    if (p->r1.n)
	PSF_FREE(phi1);
    if (p->r2.n)
	PSF_FREE(phi2);
    if (p->flag) {
	tmp = PSF_NMALLOC(char, strlen(phi) + 6);
	(void) sprintf(tmp, "not(%s)", phi);
	PSF_FREE(phi);
    } else
	tmp = phi;

#ifdef HMLU_DEBUG
    (void) fprintf(stdout, "Delta(%i,%i) =  %s\n", b1->name, b2->name, tmp);
#endif

    return tmp;
}

char *remove_tt(s)
    char *s;
{
    char *t, *u;
    int i, j, l;
    bool change;

    l = strlen(s);
    t = PSF_NMALLOC(char, l);
    do {
	change = FALSE;
	l = strlen(s);
	t = PSF_NMALLOC(char, l);
	i = j = 0;
	while (s[i]) {
	    if (i + 5 < l &&
		    ((s[i] == 't' &&
		      s[i + 1] == 't' &&
		      s[i + 2] == ' ' &&
		      s[i + 3] == '&' &&
		      s[i + 4] == '&' &&
		      s[i + 5] == ' ') ||
		     (s[i] == ' ' &&
		      s[i + 1] == '&' &&
		      s[i + 2] == '&' &&
		      s[i + 3] == ' ' &&
		      s[i + 4] == 't' &&
		      s[i + 5] == 't'))) {
		i += 6;
		change = TRUE;
		continue;
	    }
	    if (i + 3 < l && s[i] == '(' &&
		    s[i + 1] == 't' &&
		    s[i + 2] == 't' &&
		    s[i + 3] == ')') {
		i += 4;
		t[j++] = 't';
		t[j++] = 't';
		change = TRUE;
		continue;
	    }
	    t[j++] = s[i];
	    i++;
	}
	t[j] = '\0';
	u = s;
	s = t;
	t = u;
    } while (change);
    PSF_FREE(t);
    return s;
}

void hmlu(s, t)
    state *s, *t;
{
    char *tmp;

    if (s->b == t->b) {
	(void) fprintf(stdout, "States %s and %s are bisimilar, %s\n",
		       s->name, t->name,
		       (s->hst == t->hst ? "rooted" : "not rooted"));
    } else {
	(void) fprintf(stdout, "States %s and %s are not bisimilar\n",
		       s->name, t->name);
	tmp = Delta(s->b, t->b);
	tmp = remove_tt(tmp);
	(void) fprintf(stdout, "Discriminating formula: %s\n", tmp);
	PSF_FREE(tmp);

    }
}
