#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "env_variables.h"
#include "psf_malloc.h"

#include "ident.h"
#include "typedef.h"
#include "globals.h"

extern int nr_blocks;		/* typedef.c */
extern block **the_blocks;	/* results.c */
extern int graph_nr;		/* results.c */

static void print_dot_name(s)
    char *s;
{
    char *t;

    t = s;
    while (*t) {
	switch (*t) {
	case '"':
	    fprintf(stdout, "_dquote_");
	    break;
	case '\'':
	    fprintf(stdout, "_quote_");
	    break;
	case '-':
	    fprintf(stdout, "_dash_");
	    break;
	case '.':
	    fprintf(stdout, "_dot_");
	    break;
	default:
	    putc(*t, stdout);
	    break;
	}
	t++;
    }

}

static void show_final_graph(nr)
    int nr;
{
    register int i, j;
    register block *b;
    register transition *t;
    bool new;
    register state *s;

    (void) fprintf(stdout, "digraph ");
    print_dot_name(filename);
    (void) fprintf(stdout, "_%i {\n", nr);
    (void) fprintf(stdout, "orientation=land\nsize=\"10.5,7.5\"\n");
    (void) fprintf(stdout, "fontsize=10\ncenter=1\n");
    for (i = 0; i < nr_blocks; i++)
	if ((b = the_blocks[i]) && (b->flag == nr)) {
	    (void) fprintf(stdout, "%i [label=\"", i);
	    if (LONG_NAMES) {
		s = b->bs;
		while (s) {
		    (void) fprintf(stdout, "%s", s->name);
		    if (s->ren)
			(void) fprintf(stdout, "(%s)", s->ren->name);
		    if (s->next)
			(void) fprintf(stdout, ", ");
		    s = s->next;
		}
		if (b->bs && b->nbs)
		    (void) fprintf(stdout, ", ");
		s = b->nbs;
		while (s) {
		    (void) fprintf(stdout, "%s", s->name);
		    if (s->ren)
			(void) fprintf(stdout, "(%s)", s->ren->name);
		    if (s->next)
			(void) fprintf(stdout, ", ");
		    s = s->next;
		}
	    } else {
		(void) fprintf(stdout, "%i", b->name);
	    }
	    (void) fprintf(stdout, "\"]\n");
	}
    for (i = 0; i < nr_blocks; i++)
	if ((b = the_blocks[i]) && (b->flag == nr)) {
	    for (j = 0; j < b->on; j++) {
		t = b->ot[j];
		new = TRUE;
		while (t) {
		    if (new) {
			(void) fprintf(stdout, "%i -> %i [label=\"%s\"]\n",
				       t->s->b->name, t->t->b->name, t->a);
		    }
		    new = (t->next &&
			   (t->a != t->next->a || t->t->b != t->next->t->b));
		    t = t->next;
		}
	    }
	}
    (void) fprintf(stdout, "}\n");
}

static void show_state_graph(nr)
    int nr;
{
    register int i;

    (void) fprintf(stdout, "digraph ");
    print_dot_name(filename);
    (void) fprintf(stdout, "_%i {\n", nr);
    (void) fprintf(stdout, "orientation=land\nsize=\"10.5,7.5\"\n");
    (void) fprintf(stdout, "fontsize=10\ncenter=1\n");
    for (i = 0; i < ss.n; i++)
	if (ss.s[i]->flag == nr) {
	    print_dot_name(ss.s[i]->name);
	    (void) fprintf(stdout, " [label=\"%s\"]\n",
			   ss.s[i]->name);
	}
    for (i = 0; i < nr_trans; i++)
	if (trans[i].s->flag == nr) {
	    print_dot_name(trans[i].s->name);
	    (void) fprintf(stdout, " -> ");
	    print_dot_name(trans[i].t->name);
	    (void) fprintf(stdout, " [label=\"%s\"]\n", trans[i].a);
	}
    (void) fprintf(stdout, "}\n");
}
void show_graph(nrs)
    int *nrs;
{
    int i;

    if (nrs) {
	for (i = 1; i <= graph_nr; i++)
	    if (nrs[i])
		show_state_graph(i);
    } else
	for (i = 1; i <= graph_nr; i++)
	    show_final_graph(i);
}
