#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "env_variables.h"
#include "psf_malloc.h"

#include "ident.h"
#include "typedef.h"
#include "globals.h"
#include "results_hmlu.h"
#include "results_dot.h"
#include "results_til.h"

FILE *in;
extern int nr_blocks;
int graph_nr = 0;
block **the_blocks;

static void make_block_list_reset_flags(b)
    block *b;
{
    register int i;
    register block *b1;

    the_blocks = PSF_NMALLOC(block *, nr_blocks);
    for (i = 0; i < nr_blocks; i++)
	the_blocks[i] = (block *) NULL;
    for (b1 = b; b1 != NULL; b1 = b1->nb) {
	the_blocks[b1->name] = b1;
	b1->flag = 0;
    }
    for (i = 0; i < ss.n; i++)
	ss.s[i]->flag = 0;
}

#define NUMBER(s) ( b ? s->b->flag  : s->flag )
#define SETNUMBER(s,n) ( b ? (s->b->flag = n)  : (s->flag = n ) )
static void split_graphs(b)
    bool b;
{
    register bool change, unnumbered;
    register int i;

    do {
	change = unnumbered = FALSE;
	for (i = 0; i < ss.n; i++)
	    if (NUMBER(ss.s[i]) == 0) {
		unnumbered = TRUE;
		SETNUMBER(ss.s[i], ++graph_nr);
		break;
	    }
	if (unnumbered)
	    do {
		change = FALSE;
		for (i = 0; i < nr_trans; i++) {
		    if (NUMBER(trans[i].s) == graph_nr &&
			    NUMBER(trans[i].t) != graph_nr) {
			change = TRUE;
			SETNUMBER(trans[i].t, graph_nr);
		    }
		    if (NUMBER(trans[i].t) == graph_nr &&
			    NUMBER(trans[i].s) != graph_nr) {
			change = TRUE;
			SETNUMBER(trans[i].s, graph_nr);
		    }
		}
	    } while (change);
    } while (unnumbered);
}

static void show_final_partition()
{
    register int i, j, tab;
    register block *b;
    register transition *t;
    bool new;
    register state *s;

    for (i = 0; i < nr_blocks; i++) {
	if (b = the_blocks[i]) {
	    (void) fprintf(stdout, "\nBlock %i\n", b->name);
	    (void) fprintf(stdout, "\tbottom states:\n\t\t");
	    s = b->bs;
	    while (s) {
		(void) fprintf(stdout, "%s", s->name);
		if (s->ren)
		    (void) fprintf(stdout, "(%s)", s->ren->name);
		if (s->next)
		    (void) fprintf(stdout, ", ");
		s = s->next;
	    }
	    (void) fprintf(stdout, "\n");
	    (void) fprintf(stdout, "\tnon bottom states:\n\t\t");
	    s = b->nbs;
	    while (s) {
		(void) fprintf(stdout, "%s", s->name);
		if (s->ren)
		    (void) fprintf(stdout, "(%s)", s->ren->name);
		if (s->next)
		    (void) fprintf(stdout, ", ");
		s = s->next;
	    }
	    (void) fprintf(stdout, "\n");
	    for (j = 0; j < b->on; j++) {
		t = b->ot[j];
		new = TRUE;
		while (t) {
#define INDENT 32
		    if (new) {
			if ((t->s->b == t->t->b) && (t->a == skip))
			    tab = INDENT - fprintf(stdout, "Inert transitions");
			else
			    tab = INDENT - fprintf(stdout,
						 "Block %i --%s-> Block %i",
					  t->s->b->name, t->a, t->t->b->name);
		    } else
			tab = INDENT - 1;
		    new = (t->next &&
			   (t->a != t->next->a || t->t->b != t->next->t->b));
		    if (tab < 0)
			tab = 0;
		    tab /= 8;
		    while (tab--)
			(void) fprintf(stdout, "\t");
		    (void) fprintf(stdout, "\t%s --%s-> %s\n",
				   t->so, t->a, t->to);
		    t = t->next;
		}
	    }
	}
    }
}


static bool equal(i, j)
    register transition *i, *j;

{
    if (i == j)
	return TRUE;
    if (!i || !j)
	return FALSE;

    if (i->a != j->a)
	return FALSE;
    if (i->t->b->name != j->t->b->name)
	return FALSE;
    if (i->so != j->so)
	return FALSE;
    if (i->to != j->to)
	return FALSE;
    return TRUE;
}

static bool less(i, j)
    register transition *i, *j;

{
    if (!i)
	return FALSE;
    if (!j)
	return TRUE;
    if (i->a < j->a)
	return TRUE;
    if (i->a > j->a)
	return FALSE;
    if (i->t->b->name < j->t->b->name)
	return TRUE;
    if (i->t->b->name > j->t->b->name)
	return FALSE;
    if (i->so < j->so)
	return TRUE;
    if (i->so > j->so)
	return FALSE;
    if (i->to < j->to)
	return TRUE;
    if (i->to > j->to)
	return FALSE;
    return FALSE;

}

static void sort_block_trans(b)
    block *b;

{
    int i;
    transition *t, *t1;

    for (i = 0; i < b->on; i++) {
	t = b->ot[i];
	b->ot[i] = (transition *) NULL;
	while (t) {
	    if (less(t, b->ot[i])) {
		t->next = b->ot[i];
		b->ot[i] = t;
	    } else {
		t1 = b->ot[i];
		while (less(t1->next, t))
		    t1 = t1->next;
		t->next = t1->next;
		t1->next = t;
	    }
	    t = t->fnext;
	}
	while (b->ot[i] && equal(b->ot[i], b->ot[i]->next))
	    b->ot[i] = b->ot[i]->next;
	t = b->ot[i]->next;
	while (t) {
	    if (equal(t, t->next))
		t->next = t->next->next;
	    else
		t = t->next;

	}
    }
}

static bool trans_sorted = FALSE;
static void sort_trans(b)
    block *b;

{
    register int i;
    register block *b1;

    if (trans_sorted)
	return;
    trans_sorted = TRUE;
    /* move states from removed skip cycles into the block they belong */
    for (i = 0; i < ss.n; i++)
	if (ss.s[i]->ren /* && !ss.s[i]->created */ ) {
	    ss.s[i]->b = ss.s[i]->ren->b;
	    if (ss.s[i]->ren->fit.n) {
		ss.s[i]->next = ss.s[i]->b->nbs;
		ss.s[i]->b->nbs = ss.s[i];
	    } else {
		ss.s[i]->next = ss.s[i]->b->bs;
		ss.s[i]->b->bs = ss.s[i];
	    }
	}
    b1 = b;
    while (b1) {
	sort_block_trans(b1);
	b1 = b1->nb;
    }
}

void getstates(s, t)
    state **s, **t;

{
    char line[1000];
    ident tmp;
    int i, error, l;

    *s = *t = (state *) NULL;
    (void) fprintf(stdout, "After 5 unknown states you get back to the menu\n");
    i = 0;
    error = 0;
    do {
	(void) fprintf(stdout, "Give first state: ");
	fflush(stdout);
	l = fscanf(in, "%s", line);
	if (l && !feof(in)) {
	    tmp = make_ident(line);
	    for (i = 0; i < ss.n; i++)
		if (ss.s[i]->name == tmp)
		    break;
	    if (i == ss.n) {
		(void) fprintf(stdout, "%s: unknown state \"%s\"\n",
			       progname, line);
		error++;
	    }
	} else
	    error++;
	if (error > 5 || feof(in))
	    return;
    }
    while (i == ss.n);
    *s = ss.s[i];
    do {
	(void) fprintf(stdout, "Give secondstate: ");
	fflush(stdout);
	l = fscanf(in, "%s", line);
	if (l && !feof(in)) {
	    tmp = make_ident(line);
	    for (i = 0; i < ss.n; i++)
		if (ss.s[i]->name == tmp)
		    break;
	    if (i == ss.n) {
		(void) fprintf(stdout, "%s: unknown state \"%s\"\n",
			       progname, line);
		error++;
	    }
	} else
	    error++;
	if (error > 5 || feof(in))
	    return;
    }
    while (i == ss.n);
    *t = ss.s[i];
}

void show_states(p)
    block *p;

{
    block *b1;
    state *t;

    b1 = p;
    while (b1) {
	(void) fprintf(stdout, "Block %i: ", b1->name);
	t = b1->bs;
	while (t) {
	    (void) fprintf(stdout, "%s", t->name);
	    if (t->ren)
		(void) fprintf(stdout, "(%s)", t->ren->name);
	    if (t->next || b1->nbs)
		(void) fprintf(stdout, ", ");
	    t = t->next;
	}
	t = b1->nbs;
	while (t) {
	    (void) fprintf(stdout, "%s", t->name);
	    if (t->ren)
		(void) fprintf(stdout, "(%s)", t->ren->name);
	    if (t->next)
		(void) fprintf(stdout, ", ");
	    t = t->next;
	}
	(void) fprintf(stdout, "\n");
	b1 = b1->nb;
    }
}

void questions(p, states, final, shmlu)
    block *p;
    bool states;
    bool final;
    char *shmlu;

{
    state **s;
    ident *ids, tmp;
    int nids, mids;
    int il, i, j;
    bool *nrs = (bool *) NULL;

    sort_trans(p);
    make_block_list_reset_flags(p);
    if (states && !OUTPUT)
	show_states(p);
    if (final && !OUTPUT)
	show_final_partition();
    if (OUTPUT && OUTPUT_LANG == DOT && !shmlu)
	split_graphs(TRUE);
    if (OUTPUT && shmlu)
	split_graphs(FALSE);
    if (shmlu) {
	nids = 0;
	mids = 100;
	ids = PSF_NMALLOC(ident, mids + 1);
	nrs = PSF_NMALLOC(bool, ss.n);
	for(i=0;i<ss.n;i++) nrs[i]=FALSE;
	nids = 1;
	ids[0] = shmlu;
	il = 0;
	ids[0] = tmp = shmlu;
	while (*tmp) {
	    if ((*tmp == ',') && (il == 0)) {
		if (nids >= mids) {
		    mids += 10;
		    ids = PSF_REALLOC(ids, ident, mids + 1);
		}
		*tmp = '\0';
		ids[nids++] = tmp + 1;
	    }
	    if (*tmp == '(')
		il++;
	    if ((*tmp == ')') && il)
		il--;
	    tmp++;
	}
	s = PSF_NMALLOC(state *, nids);
	for (i = 0; i < nids; i++) {
	    ids[i] = make_ident(ids[i]);
	    for (j = 0; j < ss.n; j++)
		if (ss.s[j]->name == ids[i])
		    break;
	    if (j == ss.n) {
		s[i] = (state *) NULL;
		(void) fprintf(stderr, "%s: state %s does not exist\n",
			       progname, ids[i]);
	    } else
		s[i] = ss.s[j];

	}
	if (OUTPUT) {
	    for (i = 0; i < nids; i++)
		if (s[i])
		    nrs[s[i]->flag] = TRUE;
	} else {
	    for (i = 0; i + 1 < nids; i += 2)
		if (s[i] && s[i + 1])
		    hmlu(s[i], s[i + 1]);
	}
    }
    if (OUTPUT && OUTPUT_LANG == DOT)
	show_graph(nrs);
    if (OUTPUT && OUTPUT_LANG == TIL)
	show_til(nrs);
}

void interactive_questions(p)
    block *p;			/* final partition */

{
    bool cont;
    int choice, nr;
    state *s, *t;
    int i;

    if (VERBOSE)
	(void) fprintf(stdout,
		       "Doing some preprocessing for printing results\n");
    sort_trans(p);
    cont = TRUE;
    /* clearerr(stdin);  */
    in = fopen("/dev/tty", "r");
    while (cont && !feof(in)) {
	choice = 0;
	(void) fprintf(stdout, "\n1) Show final partition\n");
	(void) fprintf(stdout, "2) Create HMLU formula\n");
	(void) fprintf(stdout, "3) List states\n");
	(void) fprintf(stdout, "4) Quit\n");
	(void) fprintf(stdout, "Enter your choice 1,2,3,4: ");
	fflush(stdout);
	nr = fscanf(in, "%i", &choice);
	if (nr != 1) {
	    do {
		i = getc(in);
	    } while ((i != '\n') && (i != EOF));

	    if (i == EOF) {
		(void) fprintf(stdout, "\n");
		return;
	    }
	    choice = 0;
	}
	switch (choice) {
	case 1:
	    show_final_partition();
	    break;
	case 2:
	    getstates(&s, &t);
	    if (s && t)
		hmlu(s, t);
	    break;
	case 3:
	    show_states(p);
	    break;
	case 4:
	    cont = FALSE;
	    break;
	default:
	    (void) fprintf(stdout,
			   "You entered an invalid number, try again\n");
	    break;
	}
    }
}
