#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_standards.h"
#include "psf_malloc.h"

#include "typedef.h"
#include "globals.h"

block *to_be_processed;
block *stable;
static block_set bl;		/* visited blocks, possible splittable */
static block_set rl;		/* visited blocks, for creating r1,r2 */
static state_set vs;		/* visited states */
static bool new_bottom_states = FALSE;

static bool splittable(b, sa, sb)
    register block *b;
    register ident sa;
    register block *sb;
{
    register unsigned j, k;
    register int i;
    register block *lc, *rc;
    register block *bt;
    register state *s, *s1;
    register transition *t, *t1, *lis0, *lis1;

    s = b->bs;
    while (s && s->flag)
	s = s->next;
    if (!s) {

#ifdef DEBUG_PARTITION
	(void) fprintf(stdout, ", this block could not be split\n");
#endif

	return FALSE;
    }

#ifdef DEBUG_PARTITION
    (void) fprintf(stdout, ", indeed it could be split\n");
    print_block(b);
#endif

    b->lc = lc = new_block();	/* can perform sa (splitter action) into sb
				 * (splitter blok) */
    b->rc = rc = new_block();	/* can not see above */
    b->sa = sa;
    b->sb = sb;
    lc->hight = rc->hight = b->hight + 1;
    /* start partitioning B */
    lc->p = rc->p = b;
    t = b->is;
    while (t) {			/* mark backward through inert transitions 
				 * assumes b->is in good order */
				
	if (t->t->flag && !t->s->flag) {
	    t->s->flag = TRUE;
	    vs.s[vs.n++] = t->s;
	}
	t = t->next;
    }
    /* move states to new blocks first bottom states */

    lc->bs = rc->bs = lc->nbs = rc->nbs = (state *) NULL;
    s = b->bs;
    while (s) {
	s1 = s->next;
	if ( s->flag)
	   bt = s->b = lc;
	else 
	   bt = s->b = rc;
	s->next = bt->bs;
	bt->bs = s;
	s = s1;
    }
    /* and now non bottom states, checking on new bottom acting appropiate */
    s = b->nbs;
    while (s) {
	s1 = s->next;
	if ( s->flag)
	   bt = s->b =  lc;
	else 
	    bt = s->b =  rc;
	for (j = k = 0; j < s->fit.n; j++)
	    if (s->flag == s->fit.s[j]->flag)
		s->fit.s[k++] = s->fit.s[j];
	s->fit.n = k;
	if (k == 0) {
	    new_bottom_states = TRUE;
	    s->next = bt->bs;
	    bt->bs = s;
	} else {
	    s->next = bt->nbs;
	    bt->nbs = s;
	}
	s = s1;
    }

    /*
     * adjust is, nis move resulting non inert skip transitions to the correct
     * block
     */

    t = b->nis;
    while (t) {
	t1 = t->next;
	t->next = t->t->b->nis;
	t->t->b->nis = t;
	t = t1;

    }
    t = b->is;
    lis0 = (transition *) NULL; /* last inert transition with flag 0/1 */
    lis1 = (transition *) NULL;
    while (t) {
	t1 = t->next;
	bt = t->t->b;
	if (t->s->b != bt) {
		/* no more inert */
	    t->next = bt->nis;
	    bt->nis = t;
	} else {		/* still inert, have to keep sorting order */
	    if (t->t->flag) {
		if (lis1)
		    lis1->next = t;
		else
		    bt->is = t;
		lis1 = t;
		break;
	    } else {
		if (lis0)
		    lis0->next = t;
		else
		    bt->is = t;
		lis0 = t;
		break;
	    }
	}
	t = t1;
    }
    if (lis0)
	lis0->next = (transition *) NULL;
    if (lis1)
	lis1->next = (transition *) NULL;

    /* move transitions to new blocks */
    if (b->in) {
	lc->it = b->it;
	rc->it = new_ta(b->in);

    	for (i = 0; i < b->in; i++) {
	    t = b->it[i];
	    lc->it[i] = rc->it[i] = (transition *) NULL;
	    while (t) {
		t1 = t->next;
		t->next = t->t->b->it[i];
		t->t->b->it[i] = t;
		t = t1;
	    }
	}
	for (lc->in = rc->in = i = 0; i < b->in; i++) {
	    if (lc->it[i])
		lc->it[lc->in++] = lc->it[i];
	    if (rc->it[i])
		rc->it[rc->in++] = rc->it[i];
	}
    } else
	lc->in = rc->in = 0;

    if (b->on) {
	lc->ot = b->ot;
	rc->ot = new_ta(b->on);

	for (i = 0; i < b->on; i++) {
	    t = b->ot[i];
	    lc->ot[i] = rc->ot[i] = (transition *) NULL;
	    while (t) {
		t1 = t->fnext;
		t->fnext = t->s->b->ot[i];
		t->s->b->ot[i] = t;
		t = t1;
	    }
	}
	for (lc->on = rc->on = i = 0; i < b->on; i++) {
	    if (lc->ot[i])
		lc->ot[lc->on++] = lc->ot[i];
	    if (rc->ot[i])
		rc->ot[rc->on++] = rc->ot[i];
	}
    } else
	lc->on = rc->on = 0;

    if (rc->on) {
	rl.n = 0;
	/* create r1, r^P_skip(b->rc) */
	if (rc->ot[0]->a == skip) {
	    t = rc->ot[0];
	    lc->rflag = TRUE;
	    rc->rflag = TRUE;
	    while (t) {
		bt = t->t->b;
		if (!bt->rflag) {
		    rl.b[rl.n++] = bt;
		    bt->rflag = TRUE;
		}
		t = t->fnext;
	    }
	    lc->rflag = FALSE;
	    rc->rflag = FALSE;
	}
	b->r1.n = rl.n;
	if (rl.n) {
	    b->r1.b = block_array(rl.n);
	    for (i = 0; i < rl.n; i++) {
		b->r1.b[i] = rl.b[i];
		rl.b[i]->rflag = FALSE;
	    }
	}
	/* create r2, r_alpha(b->rc)  (=rc) */
	for (i = 0; i < rc->on; i++)
	    if (rc->ot[i]->a == sa)
		break;
	rl.n = 0;
	if (rc->on != i) {
	    t = rc->ot[i];
	    while (t) {
		bt = t->t->b;
		if ((bt == lc) || (bt == rc))
		    bt = b;
		if (!bt->rflag) {
		    rl.b[rl.n++] = bt;
		    bt->rflag = TRUE;
		}
		t = t->fnext;
	    }
	}
	b->r2.n = rl.n;
	if (rl.n) {
	    b->r2.b = block_array(rl.n);
	    for (i = 0; i < rl.n; i++) {
		b->r2.b[i] = rl.b[i];
		rl.b[i]->rflag = FALSE;
	    }
	}
    } else
	b->r1.n = b->r2.n = 0;

#ifdef DEBUG_PARTITION
    print_block(b);
    print_block(lc);
    print_block(rc);
#endif

    /* remove b from the list (stable,to_be_processed) it is in */

    if (b->pb == (block *) NULL) {	/* first of a list */
	if (b == stable) {
	    stable = stable->nb;
	    if (stable)
		stable->pb = (block *) NULL;
	} else {
	    to_be_processed = to_be_processed->nb;
	    if (to_be_processed)
		to_be_processed->pb = (block *) NULL;
	}
    } else {			/* somewhere in a list */
	b->pb->nb = b->nb;
	if (b->nb) {
	    b->nb->pb = b->pb;
	}
    }


    /* add lc,rc to to_be_processed */
    lc->nb = rc;
    lc->pb = (block *) NULL;
    rc->pb = lc;
    rc->nb = to_be_processed;
    if (to_be_processed)
	to_be_processed->pb = rc;
    to_be_processed = lc;
    return TRUE;
}

static bool try_split_on_action(i)
    register int i;
{
    register int j;
    register bool split;
    register state *s;
    register block *tbp;
    register ident a;
    register transition *t;

    tbp = to_be_processed;
    if (i >= 0) {
	a = tbp->it[i]->a;
	t = tbp->it[i];
    } else {
	a = skip;
	t = tbp->nis;
    }
    bl.n = vs.n = 0;
    split = FALSE;
    while (t) {
	s = t->s;
	if (!s->flag) {
	    s->flag = TRUE;
	    vs.s[vs.n++] = s;
	    if (!s->b->flag) {
		s->b->flag = TRUE;
		bl.b[bl.n++] = s->b;
	    }
	}
	t = t->next;
    }

#ifdef DEBUG_PARTITION
    if (!bl.n) {
	(void) fprintf(stdout, "Trying (Block %i, %s) as splitter for ",
		       tbp->name, a);
	(void) fprintf(stdout, "No Block\n");
    }
#endif

    for (j = 0; j < bl.n; j++) {
	bl.b[j]->flag = FALSE;

#ifdef DEBUG_PARTITION
	(void) fprintf(stdout, "Trying (Block %i, %s) as splitter for ",
		       tbp->name, a);
	(void) fprintf(stdout, "Block %i", bl.b[j]->name);
#endif

	split |= splittable(bl.b[j], a, tbp);
    }
    for (j = 0; j < vs.n; j++)
	vs.s[j]->flag = FALSE;
    return split;
}

static void try_first_of_tbp()
{
    register int i, j;
    register block *b;
    register bool splitter;

#ifdef DEBUG_PARTITION
    int name;

    name = to_be_processed->name;
#endif

    splitter = FALSE;
    j = to_be_processed->in;
    for (i = 0; i < j; i++) {
	if (try_split_on_action(i)) {
	    splitter = TRUE;
	    break;
	}
    }

    if (!splitter && to_be_processed->nis) {
	splitter = try_split_on_action((int) -1);	/* try split on skip */
    }
    if (splitter) {
	if (new_bottom_states && stable) {
	    if (to_be_processed) {
		b = to_be_processed;
		while (b->nb)
		    b = b->nb;
		b->nb = stable;
		stable->pb = b;
		stable = (block *) NULL;
	    } else {
		to_be_processed = stable;
		stable = (block *) NULL;
	    }
	}
	new_bottom_states = FALSE;
    } else {
	/* no splitter therefore stable */

#ifdef DEBUG_PARTITION
	(void) fprintf(stdout, "Block %i is stable\n", name);
#endif

	b = to_be_processed;
	to_be_processed = b->nb;
	if (to_be_processed)
	    to_be_processed->pb = (block *) NULL;
	b->nb = stable;
	b->pb = (block *) NULL;
	if (stable)
	    stable->pb = b;
	stable = b;
    }
}

block *partition(b)
    block *b;

{

#ifdef DEBUG_PARTITION
    int i;

    i = 0;
    print_block(b);
#endif

    stable = (block *) NULL;
    to_be_processed = b;
    b->pb = b->nb = (block *) NULL;
    vs.s = PSF_NMALLOC(state *, ss.n);
    bl.b = PSF_NMALLOC(block *, ss.n);	/* at least one state per block. */
    rl.b = PSF_NMALLOC(block *, ss.n);
    while (to_be_processed) {

#ifdef DEBUG_PARTITION
	(void) fprintf(stdout, "\n\nSplitting, cycle %i\n", i);
	(void) fprintf(stdout, "Stable: ");
	print_block_list_names(stable);
	(void) fprintf(stdout, "To be processed: ");
	print_block_list_names(to_be_processed);
	i++;
#endif

	try_first_of_tbp();
    }
    return stable;
}
