#include <stdio.h>
#include <stdlib.h>
#include "psf_prototype.h"
#include "psf_malloc.h"

#include "ident.h"
#include "typedef.h"
#include "globals.h"

static transition *no_action;
static transition *action;
static int nr_a, nr_no_a;

static void print_tables()
{
    register int i;

    for (i = 0; i < nr_a; i++)
	(void) fprintf(stdout, "%s --%s-> %s\n",
		       action[i].s->name,
		       action[i].a,
		       action[i].t->name);
    for (i = 0; i < nr_no_a; i++)
	(void) fprintf(stdout, "%s --> %s\n",
		       no_action[i].s->name,
		       no_action[i].t->name);
    (void) fprintf(stdout, "\n\n");
}

static void expand_tables()
{
    register int i, j, m;

    m = nr_trans;
    /*
     * translating p = q , q = r into p = q, q = r , p = r , transitive closure
     * and avoiding p = p
     */
    for (i = 0; i < nr_no_a; i++)
	for (j = 0; j < nr_no_a; j++) {
	    if (no_action[i].t == no_action[j].s &&
		    no_action[i].s != no_action[j].t &&
		    no_action[i].s != no_action[j].s) {
		if (nr_no_a == m) {
		    m *= 2;
		    no_action = PSF_REALLOC(no_action, transition, m);
		}
		no_action[nr_no_a].s = no_action[i].s;
		no_action[nr_no_a++].t = no_action[j].t;
	    }
	}
    /*
     * applying closure to transitions with action p = q & q = a.t into q =
     * a.t, p = a.t
     */
    m = nr_trans;
    for (i = 0; i < nr_no_a; i++)
	for (j = 0; j < nr_a; j++) {
	    if (action[j].s == no_action[i].t) {
		if (nr_a == m) {
		    m *= 2;
		    action = PSF_REALLOC(action, transition, m);
		}
		action[nr_a].s = no_action[i].s;
		action[nr_a].a = action[j].a;
		action[nr_a++].t = action[j].t;
	    }
	}
}

#define FIT_GROWTH 10
static void make_fit()
{
    register int i;
    register state_set *ss;
    register transition *t;

    for (i = 0; i < nr_trans; i++) {
	/* no self loops */
	t = &(trans[i]);
	if (t->a == skip) {
	    t->s->hst = TRUE;
	    if (t->s != t->t) {
		ss = &(t->s->fit);
		if (ss->n >= ss->m) {
		    if (ss->m) {
			ss->m *= 2;
			ss->s = PSF_REALLOC(ss->s, state *, ss->m);
		    } else {
			ss->m = FIT_GROWTH;
			ss->s = PSF_NMALLOC(state *, FIT_GROWTH);
		    }
		}
		ss->s[ss->n++] = trans[i].t;
	    }
	}
    }
}

void make_transitions()
{
    register int i;

    no_action = PSF_NMALLOC(transition, nr_trans);
    action = PSF_NMALLOC(transition, nr_trans);
    nr_a = nr_no_a = 0;
    for (i = 0; i < nr_trans; i++) {
	if (trans[i].a)
	    action[nr_a++] = trans[i];
	else if (trans[i].s != trans[i].t)
	    no_action[nr_no_a++] = trans[i];
    }

    expand_tables();
    PSF_FREE(no_action);
    PSF_FREE(trans);
    trans = action;
    nr_trans = nr_a;
    trans = PSF_REALLOC(trans, transition, nr_trans);

    make_fit();
    if (VERBOSE_MAKE)
	for (i = 0; i < nr_trans; i++)
	    (void)
		fprintf(stdout, "%s --%s-> %s\n",
			trans[i].s->name, trans[i].a, trans[i].t->name);
}
