#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_standards.h"
#include "psf_malloc.h"

#include "typedef.h"
#include "initial_block.h"
#include "ident.h"
#include "globals.h"
#define RED 0
#define BLUE 1
#define GREEN 2


static void rename_states()
{
    register int i;
    register state *s, *t;

    for (i = 0; i < ss.n; i++) {
	t = ss.s[i];
	t->flag = 0;
	if (s = t->ren) {
	    while (s->ren)
		s = s->ren;
	    t->ren = s;
	}
    }
}

static state *state_from_cycle()
{
    register int i, j;
    register bool change;
    register state *s;

    change = TRUE;
    do {
	change = FALSE;
	for (i = 0; i < ss.n; i++) {
	    s = ss.s[i];
	    if (s->COLOR != BLUE && !s->ren) {
		for (j = 0; j < s->fit.n; j++)
		    if (s->fit.s[j]->COLOR != BLUE)
			break;
		if (j == s->fit.n) {
		    s->COLOR = BLUE;
		    change = TRUE;
		}
	    }
	}
    } while (change);

    for (i = 0; i < ss.n; i++)
	if (ss.s[i]->COLOR == RED)
	    return ss.s[i];
    return (state *) NULL;
}

/* perform renamings on skip transitions */
static void rename_skips()
{
    register int i, j;
    register state *s, *t;

    for (i = 0; i < ss.n; i++) {
	t = ss.s[i];
	for (j = 0; j < t->fit.n; j++) {
	    if (s = t->fit.s[j]->ren) {
		while (s->ren)
		    s = s->ren;
		t->fit.s[j] = s;
	    }
	}
    }
}


static char buff[100];

static void remove_skip_cycles()
{
    state_set cycle;
    register int i, j, k, new;
    register state *s;

    /* at most all states are in a cycle. */
    cycle.s = PSF_NMALLOC(state *, ss.n + 1);
    cycle.n = 0;
    cycle.m = ss.n;
    new = 0;
    while (s = state_from_cycle()) {	/* implies ss.m>0 */

#ifdef CYCLE_DEBUG
	(void) fprintf(stdout, "First of cycle %s\n", s->name);
#endif

	cycle.s[0] = s;
	cycle.n = 1;
	while (s->COLOR != GREEN) {
	    s->COLOR = GREEN;
	    for (j = 0; j < s->fit.n; j++)
		if (s->fit.s[j]->COLOR != BLUE) {
		    s = s->fit.s[j];
		    break;
		}

#ifdef CYCLE_DEBUG
	    (void) fprintf(stdout, "Next of cycle %s\n", s->name);
#endif

	    cycle.s[cycle.n++] = s;
	}
	for (k = 0; k < cycle.n - 1; k++)
	    if (cycle.s[k] == s)
		break;
	    else
		cycle.s[k]->COLOR = RED;

#ifdef CYCLE_DEBUG
	(void) fprintf(stdout, "cycle_%i:\n", new);
	for (j = k; j < cycle.n; j++)
	    if (j < cycle.n - 1) {
		if (!cycle.s[j]->created || !cycle.s[j]->ren)
		    (void) fprintf(stdout, "\t%s, ", cycle.s[j]->name);
	    } else
		(void) fprintf(stdout, "\t%s.\n", cycle.s[j]->name);
#endif

	/*
	 * we have a cycle from k+1 to cycle.n-1 (cycle.k==cycle.n-1, at least
	 * the state)
	 */
	s = new_state();
	(void) sprintf(buff, "cycle_%i", new++);
	s->name = make_ident(buff);
	s->created = TRUE;
	s->hst = TRUE;
	if (ss.n >= ss.m) {
	    ss.m += 8;
	    ss.s = PSF_REALLOC(ss.s, state *, ss.m);
	}
	put_state(s, &ss);
	for (j = k + 1; j < cycle.n; j++) {
	    s->fit.m += cycle.s[j]->fit.n;
	    cycle.s[j]->ren = s;
	}
	rename_skips();
	s->fit.s = PSF_NMALLOC(state *, s->fit.m);
	for (j = k + 1; j < cycle.n; j++)
	    for (i = 0; i < cycle.s[j]->fit.n; i++)
		if (cycle.s[j]->fit.s[i] != s)
		    s->fit.s[s->fit.n++] = cycle.s[j]->fit.s[i];

    }
    PSF_FREE(cycle.s);
}


static void rename_transitions()
{
    register int i;
    register state *s;
    register transition *t;


    for (i = 0; i < nr_trans; i++) {
	t = &trans[i];
	t->so = t->s->name;
	t->to = t->t->name;
	if (s = t->s->ren) {
	    while (s->ren)
		s = s->ren;
	    t->s = s;
	}
	if (s = t->t->ren) {
	    while (s->ren)
		s = s->ren;
	    t->t = s;
	}
    }
}

static void insert_inert_transition(b, t)
    register block *b;
    register transition *t;

{
    register transition *s;

    if (t->s == t->t)
	return;
#define BEFORE_t(x) ( x->s->flag > t->s->flag )
/* see partitioning, marking backward through inert transitions. */

    if (b->is && BEFORE_t(b->is)) {
	s = b->is;
	while (s->next && BEFORE_t(s->next))
	    s = s->next;
	t->next = s->next;
	s->next = t;
    } else {
	t->next = b->is;
	b->is = t;
    }
}

static void rec_mark_fit(s)
    register state *s;
{
    register int i;

    for (i = 0; i < s->fit.n; i++)
	if (s->flag >= s->fit.s[i]->flag) {
	    s->fit.s[i]->flag = s->flag + 1;
	    rec_mark_fit(s->fit.s[i]);
	}
}

static void initialize_bit_nr(ss)
    register state_set *ss;
{
    register int i, j;
    register state *s;

    for (i = 0; i < ss->n; i++) {
	s = ss->s[i];
	if (s->fit.n && !s->ren) {
	    if (!s->flag)
		s->flag = 1;
	    for (j = 0; j < s->fit.n; j++)
		s->fit.s[j]->flag = 0;
	}
    }
    for (i = 0; i < ss->n; i++)
	if (ss->s[i]->flag == 1)
	    rec_mark_fit(ss->s[i]);
}

static int max_it = 16;
static void insert_backward_transition(b, t)
    register block *b;
    register transition *t;
{
    register int j;

    for (j = 0; j < b->in; j++)
	if (b->it[j]->a == t->a)
	    break;
    if (j == b->in) {
	if (b->in >= max_it) {
	    max_it += 16;
	    b->it = PSF_REALLOC(b->it, transition *, max_it);
	}
	b->it[b->in++] = t;
	t->next = (transition *) NULL;
    } else {
	t->next = b->it[j];
	b->it[j] = t;
    }
}

static int max_ot = 16;
static void insert_forward_transition(b, t)
    register block *b;
    register transition *t;
{
    register int j;

    for (j = 0; j < b->on; j++)
	if (b->ot[j]->a == t->a)
	    break;
    if (j == b->on) {
	if (b->on >= max_ot) {
	    max_ot += 16;
	    b->ot = PSF_REALLOC(b->ot, transition *, max_ot);
	}
	b->ot[b->on++] = t;
	t->fnext = (transition *) NULL;
    } else {
	t->fnext = b->ot[j];
	b->ot[j] = t;
    }
}

block *initial_block()
{
    register int i;
    register state *bs, *nbs, *s;
    register block *b;
    register transition *t;

    remove_skip_cycles();
    rename_states();
    rename_transitions();
    ss.m = ss.n;
    ss.s = PSF_REALLOC(ss.s, state *, ss.m);

    if (VERBOSE_CYCLES) {
	(void) fprintf(stdout, "Resulting states with renamings:\n");
	print_state_set(ss.s, ss.m);
    }
    b = new_block();
    /* initialize backward inert transitions */
    initialize_bit_nr(&ss);
    /* initialize transitions in initial block  */
    b->in = 0;
    b->on = 0;
    b->it = PSF_NMALLOC(transition *, max_it);
    b->ot = PSF_NMALLOC(transition *, max_ot);
    for (i = 0; i < nr_trans; i++) {
	t = &trans[i];
	insert_forward_transition(b, t);
	if (t->a == skip)
	    insert_inert_transition(b, t);
	else
	    insert_backward_transition(b, t);
    }
    for (i = 0; i < b->on; i++)
	if (b->ot[i]->a == skip)
	    break;
    if (i != b->on && i != 0) {
	t = b->ot[0];
	b->ot[0] = b->ot[i];
	b->ot[i] = t;
    }
    bs = (state *) NULL;
    nbs = (state *) NULL;
    for (i = 0; i < ss.n; i++) {
	s = ss.s[i];
	if (!s->ren) {
	    s->b = b;
	    s->FLAG = FALSE;
	    if (s->fit.n) {
		s->next = nbs;
		nbs = s;
	    } else {
		s->next = bs;
		bs = s;
	    }
	}
    }
    b->bs = bs;
    b->nbs = nbs;
    b->hight = 0;
    b->p = (block *) NULL;
    return b;
}
