#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "psf_malloc.h"
#include "psf_exits.h"

#include "check_lts.h"
#include "tiltype.h"
#include "prtilparts.h"
#include "fieldex.h"
#include "typedef.h"
#include "ident.h"
#include "globals.h"


#define NO_SUCH_PROCESS_TYPE 0
#define NO_SUCH_TERM_TYPE 0

extern void print_process_expr( /* process_exp *pe */ );
static module *the_mod;
static bool add_final_tick_delta = FALSE;
static bool allready_final_tick_delta = FALSE;
static bool variable = FALSE;

typedef struct mstring {
    int l;
    char *s;
    struct mstring *next;
} mstring;

static mstring *ms = (mstring *) NULL;

static mstring *new_mstring()
{
    register mstring *tms;

    if (ms) {
	tms = ms;
	ms = ms->next;
    } else {
	tms = PSF_MALLOC(mstring);
	tms->l = 100;
	tms->s = PSF_NMALLOC(char, 100);
    }
    tms->s[0] = '\0';
    return tms;
}


#define FREE_MSTRING(tms) tms->next = ms;ms=tms

static mstring *ae_term_name(term)
    register ae_term *term;
{
    register mstring *name;
    register mstring *subs;
    register mstring *tmp;
    register char *s;
    register int i, j;
    register freeformat ff;

    if (term->t != TERM) {
	(void) fprintf(stderr,
	      "%s: I thought tupels did not exist, [%i.%i] in til file %s.\n",
		       progname, term->ind.table, term->ind.key, filename);
    }
    switch (term->ind.table) {
    case SOR:
	ff = the_mod->sor[term->ind.key].ff;
	break;
    case FUN:
	ff = the_mod->fun[term->ind.key].ff;
	break;
    case ATM:
	ff = the_mod->atm[term->ind.key].ff;
	break;
    case SET:
	ff = the_mod->set[term->ind.key].ff;
	break;
    case PRO:
	ff = the_mod->pro[term->ind.key].ff;
	break;
    case VAR:
	ff = the_mod->var[term->ind.key].ff;
	if (!variable) {
	    (void) fprintf(stderr, 
	"%s: Your specification in til file %s contains variables,\n", 
		progname, filename);
	    (void) fprintf(stderr, "    the output is most likely incorrect\n");
	    variable = TRUE;
	}
	break;
    default:
	PSF_ASSERT(NO_SUCH_TERM_TYPE);

    }
    name = new_mstring();
    s = get_ff_field("n", ff);
    if ((int)strlen(s) >= name->l) {
	name->l = strlen(s) + 1;
	name->s = PSF_REALLOC(name->s, char, name->l);
    }
    name->s = strcat(name->s, s);
    if (term->a == 0) {

#ifdef AE_DEBUG
	(void) fprintf(stdout, "ae_term_name: '%s'\n", name->s);
#endif

	return name;
    }
    subs = new_mstring();
    for (i = 0; i < term->a; i++) {
	tmp = ae_term_name(&(term->ae_list[i]));
	j = strlen(subs->s) + strlen(tmp->s) + 3;
	if (subs->l < j) {
	    subs->l = j;
	    subs->s = PSF_REALLOC(subs->s, char, j);
	}
	if (i)
	    subs->s = strcat(subs->s, ", ");
	subs->s = strcat(subs->s, tmp->s);
	FREE_MSTRING(tmp);

#ifdef AE_DEBUG
	(void) fprintf(stdout, "subs: '%s'\n", subs->s);
#endif

    }
    j = strlen(name->s) + strlen(subs->s) + 4;
    if (name->l < j) {
	name->l = j;
	name->s = PSF_REALLOC(name->s, char, j);
    }
    (void) sprintf(name->s, "%s(%s)", name->s, subs->s);
    FREE_MSTRING(subs);

#ifdef AE_DEBUG
    (void) fprintf(stdout, "ae_term_name: %s\n", name->s);
#endif

    return (name);
}
static bool is_atom(proc)
    register process_expr *proc;

{
    if (proc->fun == SKP)
	return TRUE;
    if (proc->fun != AET)
	return FALSE;
    /* proc.fun = AET */
    if (proc->proc_expr.pe2.ind.table == ATM)
	return TRUE;
    return FALSE;
}

/* not really a proc just a proc name with arguments */
static bool is_proc(proc)
    register process_expr *proc;

{
    if (proc->fun == DLK)
	return TRUE;
    if (proc->fun == AET)
	return (proc->proc_expr.pe2.ind.table == PRO ? TRUE : FALSE);
    return FALSE;
}
static char xx[] = "Well this should do it.";
static char *proc_expr_ident(p)
    register process_expr *p;

{
    register mstring *tms;

    switch (p->fun) {
    case DLK:
	return delta->name;
    case SKP:
	return skip;
    case AET:
	tms = ae_term_name(&(p->proc_expr.pe2));
	FREE_MSTRING(tms);
	return make_ident(tms->s);
    default:
	return make_ident(xx);
    }
}

/* FALSE == OK !! */
static bool check_def_tuple(def, i)
    register def_tuple *def;
    register int i;

{
    register ident s;
    register ident a;
    register ident t;
    register state *p;
    register mstring *tmp;
    register mstring *x;
    register int l;

    tmp = ae_term_name(&(def->ae_t));
    if (UNIQUE) {
	x = new_mstring();
	l = strlen(tmp->s) + strlen(filename) + 3;
	if (x->l <= l) {
	    x->s = PSF_REALLOC(tmp->s, char, l);
	    x->l = l;
	}
	x->s = strcpy(x->s, filename);
	x->s = strcat(x->s, "-");
	x->s = strcat(x->s, tmp->s);
	FREE_MSTRING(tmp);
	tmp = x;
    }
    s = make_ident(tmp->s);
    FREE_MSTRING(tmp);
    a = (ident) NULL;
    t = (ident) NULL;
    if (VERBOSE_CHECKS) {
	(void) fprintf(stdout, "%s: checking, ", progname);
	(void) fprintf(stdout, "%s = ", s);
	set_print_output_file(stdout);
	print_process_expr(&(def->p_expr));
	(void) fprintf(stdout, "\n");
    }
    switch (def->p_expr.fun) {
    case AET:
	tmp = ae_term_name(&(def->p_expr.proc_expr.pe2));
	if (def->p_expr.proc_expr.pe2.ind.table == ATM) {
	    a = make_ident(tmp->s);
	} else if (def->p_expr.proc_expr.pe2.ind.table == PRO) {
	    if (UNIQUE) {
		x = new_mstring();
		l = strlen(s) + strlen(filename) + 3;
		if (x->l <= l) {
		    x->s = PSF_REALLOC(tmp->s, char, l);
		    x->l = l;
		}
		x->s = strcpy(x->s, filename);
		x->s = strcat(x->s, "-");
		x->s = strcat(x->s, tmp->s);
		FREE_MSTRING(tmp);
		tmp = x;
	    }
	    t = make_ident(tmp->s);
	} else {
	    (void) fprintf(stderr, "%s: %s is not a process or atom name.\n",
			   progname, tmp->s);
	    FREE_MSTRING(tmp);
	    return TRUE;
	}
	FREE_MSTRING(tmp);
	break;
    case SKP:
	a = skip;
	break;
    case ALT:
	(void) fprintf(stderr, "%s: found \"+\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case SEQ:
	if (def->p_expr.proc_expr.pe3.a != 2) {
	    (void) fprintf(stderr, "%s: found \".\" of %i elements,",
			   progname, def->p_expr.proc_expr.pe3.a);
	    (void) fprintf(stderr, " this should be 2, in definition [9.%i]\n",
			   i);
	    return TRUE;
	}
	if (!is_atom(&(def->p_expr.proc_expr.pe3.pe[0]))) {
	    (void) fprintf(stderr, "%s: %s %s\n", progname,
			   "found \".\", left argument",
			   "should be an atom or skip.");
	    return TRUE;
	}
	if (!is_proc(&(def->p_expr.proc_expr.pe3.pe[1]))) {
	    (void) fprintf(stderr, "%s: %s %s\n", progname,
			   "found \".\", right argument",
			   "should be a process name or delta.");
	    return TRUE;
	}
	a = proc_expr_ident(&(def->p_expr.proc_expr.pe3.pe[0]));
	t = proc_expr_ident(&(def->p_expr.proc_expr.pe3.pe[1]));
	if (UNIQUE) {
	    x = new_mstring();
	    l = strlen(s) + strlen(filename) + 3;
	    if (x->l <= l) {
		x->s = PSF_REALLOC(tmp->s, char, l);
		x->l = l;
	    }
	    x->s = strcpy(x->s, filename);
	    x->s = strcat(x->s, "-");
	    x->s = strcat(x->s, t);
	    t = make_ident(x->s);
	    FREE_MSTRING(x);
	}
	break;
    case PAR:
	(void) fprintf(stderr, "%s: found \"||\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case SUM:
	(void) fprintf(stderr, "%s: found \"sum\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case MRG:
	(void) fprintf(stderr, "%s: found \"merge\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case ENC:
	(void) fprintf(stderr, "%s: found \"encaps\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case HID:
	(void) fprintf(stderr, "%s: found \"hide\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case IF:
	(void) fprintf(stderr, "%s: found \"if\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case DLK:
	t = make_ident("delta");
	break;
    case INTR:
	(void) fprintf(stderr, "%s: found \"intr\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    case DISR:
	(void) fprintf(stderr, "%s: found \"disr\" in definition [9.%i]\n",
		       progname, i);
	return TRUE;
	break;
    default:
	PSF_ASSERT(NO_SUCH_PROCESS_TYPE);
    }
    if (s == delta->name || s == final->name) {
	if (a)
	    (void) fprintf(stderr,
			   "%s: warning encountered %s = %s . %s\n",
			   progname, s, a, (t ? t : final->name));
	else
	    (void) fprintf(stderr,
			   "%s: warning encountered %s = %s \n",
			   progname, s, t);
    }
    if (!(p = get_state_by_name(s, &ss))) {
	p = new_state();
	p->name = s;
	put_state(p, &ss);
    }
    trans[nr_trans].s = p;
    trans[nr_trans].next = (transition *) NULL;
    trans[nr_trans].a = a;
    if (t) {
	if (!(p = get_state_by_name(t, &ss))) {
	    p = new_state();
	    p->name = t;
	    put_state(p, &ss);
	}
    } else {
	p = final;
	put_state(p, &ss);
	add_final_tick_delta = TRUE;
    }
    trans[nr_trans].t = p;
    nr_trans++;
    if (variable) {
	variable = FALSE;
	return TRUE;
    }
    return (FALSE);
}

void check_lts(mod)
    module *mod;

{
    bool result = FALSE;
    int i, nr;
    mstring *tmp;

    the_mod = mod;
    set_print_output_file(stderr);
    set_print_current_module(the_mod);
    nr = the_mod->entries_table[DEF];
    trans = PSF_REALLOC(trans, transition, nr_trans + nr + 2);
    ss.m = ss.n + nr * 2 + 3;
    ss.s = PSF_REALLOC(ss.s, state *, ss.m);
    for (i = 0; i <= nr; i++) {
/*
	if (the_mod->def[i].defined) {
*/
	    /* must be done first, for setting variable in def. */
	    tmp = ae_term_name(&(the_mod->def[i].ae_t));
	    if (check_def_tuple(&(the_mod->def[i]), i)) {
		result = TRUE;
		(void) fprintf(stderr, "\t%s = ", tmp->s);
		set_print_output_file(stderr);
		print_process_expr(&(the_mod->def[i].p_expr));
		(void) fprintf(stderr, "\n");
	    }
	    FREE_MSTRING(tmp);
/*
	}
*/
    }
    if (add_final_tick_delta && !allready_final_tick_delta) {
	allready_final_tick_delta = TRUE;
	trans[nr_trans].s = final;
	trans[nr_trans].a = tick;
	trans[nr_trans].t = delta;
	nr_trans++;
	put_state(final, &ss);
	put_state(delta, &ss);
    }
    if (result) {
	(void) fprintf(stderr,
     "%s: this program expects a linear transition system without variables.\n",
							 progname);
	(void) fprintf(stderr, "    try using trans first.\n");
	exit(EXIT_SYNTAX_ERR);
    }
}
