'\" t
.TH BB 1L "Nov 23, 1994" "TUE" "PSF-Toolkit"
.UC 4
.SH NAME
bb \- compute branching bisimilar classes and distinguishing formula's
.SH SYNOPSIS
.B bb
[
.B\-b
.I state,state,...
]
[
.B\-c
]
[
.B\-d
]
[
.B\-f
]
[
.B\-h
]
[
.B\-l
]
[
.B\-m
]
[
.B\-o
]
[
.B\-r
]
[
.B\-s
]
[
.B\-t
]
[
.B\-u
]
[
.B\-v
]
[
.B\-V
]
[
.I filename ...
]
.SH DESCRIPTION
The bb program takes several til modules as input, checks whether the input is
correct and computes branching bisimilar classes. The process definitions in
the input should be of the form
.nf
state = action . state
state = state
state = action
.fi
and not contain variables. The state FINAL_STATE is special, this one can
perform a tick step to delta. This internal tick is different from user
provided ticks.

The tool bb first reads the input files, stdin if none are given. The process
expressions contained in the input are checked and converted to the internal
representation, where after all definitions are rewritten to a form
.nf
state = action . state.
An example:
p = a . q
p = q
q = b
.fi
Where p,q are process names and a,b are atom names. Above expressions will be
transformed to the following set of transitions:
.nf
p = a . q
p = b . FINAL_STATE
q = b . FINAL_STATE
FINAL_STATE = tick . delta
.fi
This last transition is added to distinguish successful termination from
deadlock.

After creating the internal representation bb performs a partitioning
algorithm, described in 
.nf
J.F. Groote and F.W. Vaandrager
An efficient algorithm for branching bisimulation and
stuttering equivalence
In M.S. Paterson, editor, Proceedings 17th ICALP, Warwick, volume 443
of Lecture Notes in Computing Science, pages 626-638.
Springer-Verlag
1990.
.fi

and finally displays a menu, if in interactive mode,
with the following option.
.nf
1) Show final partition
2) Create HMLU formula
3) List states
4) Quit
.fi
The algorithm to create the HMLU formulas is described in
.nf
E.E. Polak
An efficient implementation of Branching Bisimulation
and Distinguishing Formulae
University of Amsterdam
Programming Research Group
Report P9216
August 1992.
.fi
.SH OPTIONS
.TP
.B \-b
.I state,state,...
If states are not bisimilar compute distinguishing formula. If the 
.I -o
or
.I -d
option is used input graphs containing those states are printed in the
corresponding language.
.TP
.B \-c
print process expressions while checking them.
.TP
.B \-d
print final partition in dot input format , no other output generating options
should be used.
Interactive questioning will not take place. See also the 
.I -b
option.
Dot is a tool which can draw a graph given a set of transitions.
.TP
.B \-f
print final partition
.TP
.B \-h
Prints a usage message, and exits without further processing.
.TP
.B \-l
Create long names when printing final partition as dot or til.
This is, use the set of states as name instead of the block number.
.TP
.B \-m
print transitions found
.TP
.B \-r
no interactive questioning
.TP
.B \-o
print final partition as til, no other output generating options should be used.
Interactive questioning will not take place. See also the 
.I -b
option.
.TP
.B \-s
print equivalence classes and renamings
.TP
.B \-t
time partitioning
.TP
.B \-u
postfix state names with filename
.TP
.B \-v
verbose mode
.TP
.B \-V
very verbose mode

.SH SEE ALSO
.BR 
psf(1L),
til.bnf(5),
trans(1L)
.SH DIAGNOSTICS 
At the moment no decent preprocessor which creates linear transition
systems from process specifications exists.
.SH Bugs
Well of course
.SH AUTHORS
.TP
Mark van Wijk, Eindhoven Univ. of Techn. (markvw@win.tue.nl)
