#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_standards.h"
#ifdef THIS_IS_ITIL_TIL
#include "realkey.h"
#include "xtiltype.h"
#else
#include "tiltype.h"
#endif

#include "write_subs_til.h"
#include "writetil.h"
#include "printed_tuples.h"

void write_subs_index(ind)
    struct indextype *ind;
{
    if (!printed(ind->table,

#ifdef THIS_IS_ITIL_TIL
		 get_real_key(ind)
#else
		 ind->key
#endif

		 ))
	write_tuple(ind->table,

#ifdef THIS_IS_ITIL_TIL
		    get_real_key(ind)
#else
		    ind->key
#endif

	    );
}

void write_subs_indexlist(ind_l)
    struct indexlist *ind_l;
{
    int anum;

    for (anum = 0; anum < ind_l->a; anum++)
	write_subs_index(&ind_l->indlist[anum]);
}

void write_subs_ae_term(ae_t)
    struct ae_term *ae_t;
{
    int anum;

    if (ae_t->t == TUPLE) {
	for (anum = 0; anum < ae_t->a; anum++)
	    write_subs_ae_term(&ae_t->ae_list[anum]);
    } else {
	write_subs_index(&ae_t->ind);
	if (ae_t->a > 0) {
	    for (anum = 0; anum < ae_t->a; anum++)
		write_subs_ae_term(&ae_t->ae_list[anum]);
	}
    }
}

void write_subs_s_term(s_t)
    struct s_term *s_t;
{
    int anum;

    for (anum = 0; anum < s_t->a; anum++) {
	if (s_t->u_tag[anum] == 0)
	    write_subs_ae_term(s_t->arr[anum].ae_t);
	else
	    write_subs_s_term(s_t->arr[anum].s_t);
    }
}

void write_subs_pr_expr(p_expr)
    struct process_expr *p_expr;
{
    int anum;

    if (p_expr->fun == AET) {
	write_subs_ae_term(&p_expr->proc_expr.pe2);
    } else {
	switch (p_expr->fun) {
	case SKP:
	    break;
	case SUM:
	case MRG:
	case ENC:
	case HID:
	    write_subs_index(&p_expr->proc_expr.pe1.ind);
	    write_subs_pr_expr(p_expr->proc_expr.pe1.pe);
	    break;
	case ALT:
	case SEQ:
	case PAR:
	case INTR:
	case DISR:
	case STAR:
	case SHARP:
	    for (anum = 0; anum < p_expr->
		    proc_expr.pe3.a; anum++)
		write_subs_pr_expr(&p_expr->
				   proc_expr.pe3.pe[anum]);
	    break;
	case DLK:
	    break;
	case IF:
	    write_subs_ae_term(&p_expr->proc_expr.pe4.aex);
	    write_subs_ae_term(&p_expr->proc_expr.pe4.aey);
	    write_subs_pr_expr(p_expr->proc_expr.pe4.pe);
	    break;
	case PRIO:
	    write_subs_indexlist(&p_expr->proc_expr.pe5.sets);
	    write_subs_pr_expr(p_expr->proc_expr.pe5.pe);
	    break;
	}
    }
}

void write_subs_sor_tuple(sor)
    sor_tuple *sor;
{
    sor = sor;			/* to shut up lint */
}

void write_subs_fun_tuple(fun)
    fun_tuple *fun;
{
    write_subs_indexlist(&fun->sor_indlist);
    write_subs_indexlist(&fun->return_list);
}

void write_subs_atm_tuple(atm)
    atm_tuple *atm;
{
    write_subs_indexlist(&atm->sor_indlist);
}

void write_subs_pro_tuple(pro)
    pro_tuple *pro;
{
    write_subs_indexlist(&pro->sor_indlist);
}

void write_subs_set_tuple(set)
    set_tuple *set;
{
    if (set->ind.key == 0) {
	if (!printed(set->ind.table, 0))
	    write_tuple(set->ind.table, 0);
    } else
	write_subs_index(&set->ind);
    if (set->u_tag == 0)
	write_subs_index(&set->construct.sort);
    else
	write_subs_s_term(&set->construct.set_term);
}

void write_subs_com_tuple(com)
    com_tuple *com;
{
    write_subs_ae_term(&com->aet[0]);
    write_subs_ae_term(&com->aet[1]);
    write_subs_ae_term(&com->aet[2]);
}

void write_subs_var_tuple(var)
    var_tuple *var;
{
    write_subs_index(&var->ind);
}

void write_subs_equ_tuple(equ)
    equ_tuple *equ;
{
    int c;

    write_subs_ae_term(&equ->aet1);
    write_subs_ae_term(&equ->aet2);
    if (equ->a > 0) {
	for (c = 0; c < equ->a; c++) {
	    if (c)
		write_subs_ae_term(&equ->guard[c].aet1);
	    write_subs_ae_term(&equ->guard[c].aet2);
	}
    }
}

void write_subs_def_tuple(def)
    def_tuple *def;
{
    write_subs_ae_term(&def->ae_t);
    write_subs_pr_expr(&def->p_expr);
}
