#include <stdlib.h>
#include <stdio.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "tiltype.h"
#include "printed_tuples.h"

#include "psf_malloc.h"

typedef struct str_intlist {
    int i;
    struct str_intlist *next;
} intlist;

static intlist *printed_tuples[MTABLE];

void record_as_printed(table, key)
    tabletype table;
    keytype key;

{
    intlist *il;

    il = PSF_MALLOC(intlist);
    il->i = key;
    il->next = printed_tuples[table];
    printed_tuples[table] = il;
}

bool printed(table, key)
    tabletype table;
    keytype key;

{
    intlist *il;

    for (il = printed_tuples[table]; il != NULL; il = il->next)
	if (il->i == key)
	    return TRUE;
    return FALSE;
}

void destroy_record_printed()
{
    int i;
    intlist *il;

    for (i = 0; i < MTABLE; i ++) {
	for (il = printed_tuples[i]; il != NULL; ) {
	    il = il->next;
	    PSF_FREE(printed_tuples[i]);
	    printed_tuples[i] = il;
	}
    }
}
