.TH "TRS" 3  "Oct 14, 1993" "PSF-Toolkit" ROUTINES
.SH NAME
trs, create_eqm, add_equation, eqm_setoptions, term_match, term_match_sub,
term_instantiate, subst_free, term_reduce \-
term rewriter functions used in the PSF-Toolkit
.SH SYNOPSIS
.nf
.ft B
#include "eqm.h"
.LP
.ft B
eqm_t *create_eqm (nfuns)
unsigned int nfuns;
.LP
.ft B
int *add_equation (eqm, eq)
eqm_t *eqm;
equ_tuple eq;
.LP
.ft B
int eqm_setoptions (options)
int option;
.LP
.ft B
subst_t *term_match (pattern, term)
struct ae_term *pattern;
struct ae_term *term;
.LP
.ft B
subst_t *term_match_sub (pattern, term, sub)
struct ae_term *pattern;
struct ae_term *term;
subst_t sub;
.LP
.ft B
struct ae_term *term_instantiate (pattern, sub, eqm)
struct ae_term *pattern;
subst_t *sub;
eqm_t *eqm;
.LP
.ft B
void subst_free (sub)
subst_t *sub;
.LP
.ft B
struct ae_term *term_reduce (eqm, term)
eqm_t *eqm;
struct ae_term *term;
.LP
.ft B
int term_trace;
.fi
.ft R
.SH DESCRIPTION
.B create_eqm(\|)
creates an equation-manager and returns it.
.I nfuns
is the number of functions that can appear in the equations.
.LP
.B add_equation(\|)
add the equation
.I eq
to equation_manager
.IR eqm ,
and returns the new equation-manager.
.LP
.B eqm_setoptions(\|)
sets options for the equation-manager.
Possible options are: EQM_PRINT_STATS \- which prints statistics on
matches done by the equation-manager, EQM_REVERSE \- which uses the
given equations in reverse order.
.LP
.B term_match(\|)
matches the term
.I pattern
with term
.IR term .
Substitutions for variables are returned in the structure
.IR subst_t .
If there is no match,
.B term_match(\|)
returns NULL.
.LP
.B term_match_sub(\|)
matches the term
.I pattern
with term
.IR term .
Substitutions for variables are added to
.IR sub ,
and the resulting structure of substitutions is returned.
If there is no match,
.B term_match_sub(\|)
returns NULL.
.LP
.B term_instantiate(\|)
instantiates the term
.I pattern
with the values for the variables found in
.IR sub .
The term is rewritten with the use of equation-manager
.IR eqm .
.LP
.B subst_free(\|)
frees the structure subst_t given by
.IR sub .
.LP
.B term_reduce(\|)
rewrites
.I term
with the use of equation-manager
.IR eqm .
.LP
.B term_trace
makes, when set to 1, the equation-manager show trace information.
.SH FILES
.PD 0
.TP
.B .../src/include/trs/eqm.h
.TP
.B .../src/include/trs/eqm_local.h
.TP
.B .../src/include/trs/match.c
.TP
.B .../src/include/trs/error.c
.TP
.B .../src/include/trs/equations.c
.TP
.B .../src/include/trs/eqmterm.c
.TP
.B .../src/include/trs/trs.imake
.SH AUTHOR
Casper H.S. Dik, University of Amsterdam (casper@fwi.uva.nl)
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
