/*
 * term structure thingies for PSF Term Rewriting.
 */

#include "psf_prototype.h"
#include "tiltype.h"
#include "eqm.h"
#include "eqm_local.h"
#include "psf_malloc.h"
#ifdef PRTILPSF
#include "prtilparts.h"
#else
#define print_ae_term(s)
#define print_term(s)
#endif

#ifndef NULL
#define NULL 0
#endif

term_t
* term_free_list[] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL
};

#define FREELISTSIZE (sizeof(term_free_list) / sizeof(term_t *))
int free_list_size = FREELISTSIZE;

static ae_term
*ae_list_free_list_[] = {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};

#define ae_free_list (ae_list_free_list_[0])
static ae_term **ae_list_free_list = ae_list_free_list_ - 1;

#define AE_FREELISTSIZE (sizeof(ae_list_free_list_) / sizeof(ae_term *))

#ifdef TRACEALLOC
int alloc_stats[FREELISTSIZE + 1];
static int ae_alloc_stats[AE_FREELISTSIZE + 1];
void print_alloc_stats()
{
    int i;

    printf("Term alloc stats\nsize\tnumber\tin freelist\n\n");
    for (i = 0; i < FREELISTSIZE; i++) {
	int number = 0;
	term_t *t = term_free_list[i];

	while (t != NULL) {
	    number++;
	    t = t->free_next;
	}
	printf("%8d%8d%8d\n", i, alloc_stats[i], number);
    }
    printf("other\t%8d\n\n", alloc_stats[FREELISTSIZE]);
    printf("ae_term alloc stats\nsize\tnumber\tin freelist\n\n");
    for (i = 1; i <= AE_FREELISTSIZE; i++) {
	int number = 0;
	ae_term *t = ae_list_free_list[i];

	while (t != NULL) {
	    number++;
	    t = t->ae_list;
	}
	printf("%8d%8d%8d\n", i, ae_alloc_stats[i - 1], number);
    }
    printf("other\t%8d\n\n", ae_alloc_stats[AE_FREELISTSIZE]);
}

void init_trace_alloc()
{
    static int inited = 0;

    if (!inited) {
	int i;

	inited = 1;

#ifdef HAS_ON_EXIT
	on_exit(print_alloc_stats, (char *) NULL);
#endif

	for (i = 0; i <= AE_FREELISTSIZE; i++)
	    ae_alloc_stats[i] = 0;
	for (i = 0; i <= FREELISTSIZE; i++)
	    alloc_stats[i] = 0;
    }
}

#else
void print_alloc_stats()
{
    return;
}
void init_trace_alloc()
{
    return;
}

#endif

term_t
* term_copy(term)
    term_t *term;
{
    term_t *new;
    int i;

    if (term->nsons >= FREELISTSIZE || term_free_list[term->nsons] == NULL) {
	new = (term_t *) psf_malloc(sizeof(term_t) +
				(term->nsons /* - WAS_ZERO */) * sizeof(term_t *));

#ifdef TRACEALLOC
	alloc_stats[term->nsons >= FREELISTSIZE ? FREELISTSIZE : term->nsons]++;
#endif
    } else {
	new = term_free_list[term->nsons];
	term_free_list[term->nsons] = new->free_next;
    }
    *new = *term;
    for (i = term->nsons; i-- > 0;)
	new->sons[i] = term_copy(term->sons[i]);

    new->refcnt = 1;

    return new;
}

void term_free(term)
    term_t *term;
{
    int i;

    for (i = term->nsons; i-- > 0;)
	if (--term->sons[i]->refcnt == 0)
	    term_free(term->sons[i]);

    if (term->nsons < FREELISTSIZE) {
	term->free_next = term_free_list[term->nsons];
	term_free_list[term->nsons] = term;
    } else {

#ifdef TRACEALLOC
	alloc_stats[FREELISTSIZE]--;
#endif

	free((char *) term);
    }
}



static void term2ae_term_children(term, aeterm)
    term_t *term;
    ae_term *aeterm;
{
    int i;

    if (aeterm->a > AE_FREELISTSIZE || ae_list_free_list[aeterm->a] == NULL) {
	aeterm->ae_list = PSF_NMALLOC(ae_term, aeterm->a);


#ifdef TRACEALLOC
	ae_alloc_stats[aeterm->a > AE_FREELISTSIZE ?
			AE_FREELISTSIZE : aeterm->a - 1]++;
#endif
    } else {

	aeterm->ae_list = ae_list_free_list[aeterm->a];
	ae_list_free_list[aeterm->a] = aeterm->ae_list->ae_list;
    }

    for (i = aeterm->a; i-- > 0;) {
	aeterm->ae_list[i].ind = term->sons[i]->ind;
	aeterm->ae_list[i].a = term->sons[i]->nsons;
	/*
	 * BD1 ae_term->t = TERM;
	 */
	aeterm->ae_list[i].t = TERM;
	if (term->sons[i]->nsons > 0)
	    term2ae_term_children(term->sons[i], aeterm->ae_list + i);
	else
	    aeterm->ae_list[i].ae_list = NULL;
    }
}

ae_term
*term2ae_term(term)
    term_t *term;
{
    ae_term *new;

    if (ae_free_list == NULL) {
	new = PSF_MALLOC(ae_term);

#ifdef TRACEALLOC
	ae_alloc_stats[0]++;
#endif
    } else {

	new = ae_free_list;
	ae_free_list = ae_free_list->ae_list;
    }

    new->ind = term->ind;
    new->a = term->nsons;
    new->t = TERM;

    if (new->a > 0)
	term2ae_term_children(term, new);
    else
	new->ae_list = NULL;

    return new;
}

term_t
* ae_term2term(term)
    ae_term *term;
{
    term_t *new;
    int i;

    if (term->a >= FREELISTSIZE || term_free_list[term->a] == NULL) {
	new = (term_t *) psf_malloc(sizeof(term_t) +
				term->a * sizeof(term_t *));

#ifdef TRACEALLOC
	alloc_stats[term->a > FREELISTSIZE ? FREELISTSIZE : term->a]++;
#endif
    } else {
	new = term_free_list[term->a];
	term_free_list[term->a] = new->free_next;
    }

    new->ind = term->ind;
    new->nsons = term->a;
    for (i = term->a; i-- > 0;)
	new->sons[i] = ae_term2term(term->ae_list + i);

    new->refcnt = 1;
    return new;
}

static void ae_term_free_children(term)
    ae_term *term;
{
    int i;

    if (term->a == 0)
	return;

    for (i = term->a; i-- > 0;) {
	ae_term_free_children(term->ae_list + i);
    }

    if (term->a > AE_FREELISTSIZE) {
	free((char *) term->ae_list);

#ifdef TRACEALLOC
	ae_alloc_stats[AE_FREELISTSIZE]--;
#endif
    } else {
	term->ae_list->ae_list = ae_list_free_list[term->a];
	ae_list_free_list[term->a] = term->ae_list;
    }
}

void ae_term_free(term)
    ae_term *term;
{
    ae_term_free_children(term);

    term->ae_list = ae_free_list;
    ae_free_list = term;
}

#ifdef PRTILPSF
void print_term(t)
    term_t *t;
{
    ae_term *ae_t = term2ae_term(t);

    print_ae_term(ae_t);
    ae_term_free(ae_t);
}

#endif

ae_term *get_ae_term()
{
    ae_term *new;

    if (ae_free_list == NULL) {
	new = PSF_MALLOC(ae_term);

#ifdef TRACEALLOC
	ae_alloc_stats[0]++;
#endif
    } else {

	new = ae_free_list;
	ae_free_list = ae_free_list->ae_list;
    }
    return(new);
}

ae_term *get_ae_list(a)
int a;
{
    ae_term *ae_list;

    if (a > AE_FREELISTSIZE || ae_list_free_list[a] == NULL) {
	ae_list = PSF_NMALLOC(ae_term, a);


#ifdef TRACEALLOC
	ae_alloc_stats[a > AE_FREELISTSIZE ?
			AE_FREELISTSIZE : a - 1]++;
#endif
    } else {

	ae_list = ae_list_free_list[a];
	ae_list_free_list[a] = ae_list->ae_list;
    }
    return(ae_list);
}
