/*
 * PSF rewrite system, Equation Manager local defines.
 * 
 */

#ifndef NULL
#define NULL 0
#endif

/*
 * Solaris hasn't got on_exit. Is SVR4 THE indicator for Solaris?
 */

#ifndef SVR4

#ifdef sun
#define HAS_ON_EXIT
#endif

#endif

#include "psf_malloc.h"
#include "psf_prototype.h"
#include "tiltype.h"
#include "eqm.h"

#define NMALLOC(type,n)		PSF_NMALLOC(type,n)
#define MALLOC(type)		PSF_MALLOC(type)
#define FREE(ptr)		PSF_FREE(ptr)

#define	FUN1HASH(ind)		((ind).key % PRIME1)

#define term_is_variable(term)	((term)->ind.table == VAR)

#define fun_equal(fun1,fun2)	((fun1).key == (fun2).key && \
					(fun1).table == (fun2).table)

#define op_equal(term1,term2)	fun_equal((term1)->ind,(term2)->ind)

#define var_equal(var1,var2)	((var1).key == (var2).key)

/* eqmterm.c */
extern term_t *term_copy PROTO_ARGS((term_t *term));
extern void term_free PROTO_ARGS((term_t *term));
extern ae_term *term2ae_term PROTO_ARGS((term_t *term));
extern term_t *ae_term2term PROTO_ARGS((ae_term *term));

#ifdef PRTILPSF
void  print_term PROTO_ARGS((term_t *t));
#endif
