/*
 * PSF rewrite system, Equation Manager types and misc.
 * 
 */

#ifndef EQM_H
#define EQM_H

#ifdef TERMTRACE
extern int term_trace;
#endif

#include "psf_prototype.h"
#include "tiltype.h"

#define PRIME1 17
#define WAS_ZERO 1
typedef struct term_t {
    union {
	int u_refcnt;
	struct term_t *u_free_next;
    } u_gc;
    struct indextype ind;
    int nsons;
    struct term_t *sons[WAS_ZERO];
#define refcnt		u_gc.u_refcnt
#define free_next	u_gc.u_free_next
} term_t;

typedef struct eq_list_t {
    struct eq_list_t *next_eq;
    equ_tuple this_eq;
    unsigned int ntries;
    unsigned int nsuccess;
    int cheap;
} eq_list_t;

typedef struct eq_fun_list_t {
    struct eq_list_t *eq_list[PRIME1];
    struct eq_list_t *var_eq;
} eq_fun_list_t;

typedef struct eqm_t {
    eq_fun_list_t **fun_list;
    struct eqm_t *next_eqm;
    unsigned int fun_cnt;
} eqm_t;

typedef struct subst_elem_t {
    struct subst_elem_t *next_se;
    struct indextype var;
    term_t *value;
} subst_elem_t;

typedef struct subst_t {
    union {
	subst_elem_t *un_sb_elems;
	struct subst_t *un_next_sub;	/* for garbage collecting */
    } sub_un;
    int f;
} subst_t;

#define	sb_elems sub_un.un_sb_elems
#define	next_sub sub_un.un_next_sub

#define EQM_PRINT_STATS	1
#define EQM_REVERSE	2

/* functions */

/* eqmterm.c */
extern void print_alloc_stats PROTO_ARGS((void));
extern void init_trace_alloc PROTO_ARGS((void));
extern void ae_term_free PROTO_ARGS((ae_term *term));
extern ae_term *get_ae_term PROTO_ARGS((void));
extern ae_term *get_ae_list PROTO_ARGS((int a));

/* equations.c */
extern eqm_t *create_eqm PROTO_ARGS((unsigned int nfuns));
extern eqm_t *add_equation PROTO_ARGS((eqm_t *eqm, equ_tuple eq));
extern void eqm_sort PROTO_ARGS((eqm_t *eqm));
extern void eqm_setoptions PROTO_ARGS((int options));

/* match.c */
extern subst_t *term_match_sub PROTO_ARGS((ae_term *pattern, ae_term *term, subst_t *sub));
extern subst_t *term_match PROTO_ARGS((ae_term *pattern, ae_term *term));
extern ae_term *term_instantiate PROTO_ARGS((ae_term *pattern, subst_t *sub, eqm_t *eqm));
extern void subst_free PROTO_ARGS((subst_t *sub));
extern ae_term *term_reduce PROTO_ARGS((eqm_t *eqm, ae_term *term));
extern subst_t *get_sub PROTO_ARGS((void));
#ifdef DEBUG_MEMUSE
void print_sub_count();
#endif /* DEBUG_MEMUSE */
#ifdef SUMMERGE
subst_t *copy_add_to_sub();
subst_t *copy_add_sub_to_sub();
#endif

/* error.c */
extern void EQMerror PROTO_ARGS((char *s));

#endif	/* EQM_H */
