#include <assert.h>
#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "xtiltype.h"
#include "readxtiltype.h"
#include "realkey.h"
#include "readexp.h"
#include "psf_malloc.h"
#include "psf_exits.h"

extern char *filename;
extern char *progname;
extern int lineno;
extern int linepos;
FILE *input;

#ifndef THIS_IS_ITIL_TIL
static int read_mtil = 0;

void set_read_type(t)
    int t;
{
    read_mtil = t;
}

#endif

void set_input_file(fp)
    FILE *fp;
{
    input = fp;
}

static struct module *current_module;

void set_read_current_module(mod)
    struct module *mod;
{
    current_module = mod;
}

tabletype table_nr(tid)
    int tid;
{
    switch (tid) {
    case 'P':
	return ((tabletype) PRM);
    case 'R':
	return ((tabletype) REN);
    case 'B':
	return ((tabletype) BIN);
    case 'I':
	return ((tabletype) IMP);
    case 'M':
	return ((tabletype) MOD);
    case 'U':
	return ((tabletype) UND);
    default:
	return ((tabletype) tid - '0');
    }
}

void read_index(index)
    struct indextype *index;
{
    char tid;
    int i;

    skip_space();

#ifndef THIS_IS_ITIL_TIL
    if (read_mtil) {
	read_char('[');
	skip_space();
	tid = getc(input);

#ifdef READDEBUG
	fprintf(stderr, "%c", tid);
#endif

	linepos++;
	read_char('.');
	skip_space();
	i = getc(input);
	PSF_ASSERT(ungetc(i, input)!=EOF);
	if (i == '?') {
	    index->key = -1;
	    read_char('?');
	} else
	    index->key = (keytype) read_nat();
	read_char(']');
	index->origin = 1;
	index->table = table_nr(tid);

    } else {
#endif				/* THIS_IS_ITIL_TIL */

	read_char('[');
	index->origin = read_nat();
	read_char('.');
	skip_space();
	tid = getc(input);

#ifdef READDEBUG
	fprintf(stderr, "%c", tid);
#endif

	linepos++;
	read_char('.');
	skip_space();
	i = getc(input);
	PSF_ASSERT(ungetc(i, input)!=EOF);
	if (i == '?') {
	    index->key = -1;
	    read_char('?');
	} else
	    index->key = read_nat();
	read_char(']');
	index->table = table_nr(tid);


#ifndef THIS_IS_ITIL_TIL
    }
#endif				/* THIS_IS_ITIL_TIL */

}

struct indextype *read_indexarr(nr)
    unsigned int nr;
{
    int i;
    struct indextype *indlist;

    if (!nr)
	return (NULL);
    indlist = PSF_NMALLOC(struct indextype, nr);
    for (i = 0; i < nr; i++) {
	read_index(&indlist[i]);
    }
    return (indlist);
}

void read_indexlist(il)
    struct indexlist *il;
{
    il->a = read_nat();
    il->indlist = read_indexarr(il->a);
}

freeformat
read_freeformat()
{
    char *s;
    int i, bufsize;

    int ic;

    skip_space();
    read_char('{');
    skip_space();
    bufsize = 10;
    s = PSF_NMALLOC(char, bufsize);
    i = 0;
    while ((ic = getc(input)) != '}' && ic != EOF) {
	s[i] = ic;
	if (ic == '\n') {
	    lineno++;
	    linepos = 0;
	} else
	    linepos++;
	if (++i >= bufsize) {
	    bufsize *= 2;
	    s = PSF_REALLOC(s, char, bufsize);
	}
    }
    s[i] = '\0';

#ifdef READDEBUG
    fprintf(stderr, "%s", s);
#endif

    PSF_ASSERT(ungetc(ic, input)!=EOF);
    read_char('}');
    if (i) {
	while (s[--i] == ' ')
	    s[i] = '\0';
    }
    return (s);
}

char read_tag()
{
    char c;

    skip_space();
    c = getc(input);
    linepos++;

#ifdef READDEBUG
    fprintf(stderr, "%c", c);
#endif

    return (c);
}

void read_ae_term(term)
    struct ae_term *term;
{
    unsigned int nr;
    int i;

    skip_space();
    term->t = getc(input);
    PSF_ASSERT(ungetc(term->t, input)!=EOF);
    if (term->t == TUPLE) {
	read_char('<');
	term->a = read_nat();
	term->ae_list = PSF_NMALLOC(struct ae_term, term->a);
	for (i = 0; i < term->a; i++)
	    read_ae_term(&(term->ae_list[i]));
	read_char('>');
    } else {
	read_index(&term->ind);

#ifndef THIS_IS_ITIL_TIL
	if (read_mtil)
	    i = term->ind.key;
	else
#endif				/* THIS_IS_ITIL_TIL */

	if (term->ind.table < SET)
	    /*
	     * Sets may contain foreward references, for which no real key is
	     * specified yet. Since no information is needed about this set,
	     * just leave it. Sets may also use variables which are not defined
	     * yet.
	     */
	    if (term->ind.table != SOR || term->ind.key != 0)
		i = get_real_key(&term->ind);

	if (term->ind.table == FUN)
	    nr = current_module->fun[i].sor_indlist.a;
	else if (term->ind.table == ATM)
	    nr = current_module->atm[i].sor_indlist.a;
	else if (term->ind.table == PRO)
	    nr = current_module->pro[i].sor_indlist.a;
	else
	    nr = 0;
	term->a = nr;
	if (nr == 0) {
	    term->ae_list = NULL;
	    return;
	}
	read_char('(');
	term->ae_list = PSF_NMALLOC(struct ae_term, nr);


	for (i = 0; i < nr; i++)
	    read_ae_term(&(term->ae_list[i]));
	read_char(')');

    }
}

void read_s_term(term)
    struct s_term *term;
{
    char c;
    int i;

    read_char('<');
    skip_space();
    term->fun = getc(input);
    linepos++;
    read_char(',');
    term->a = read_nat();
    read_char('>');
    read_char('(');
    term->u_tag = PSF_NMALLOC(int, term->a);
    term->arr = PSF_NMALLOC(union terms, term->a);
    for (i = 0; i < term->a; i++) {
	skip_space();
	c = getc(input);
	PSF_ASSERT(ungetc(c, input)!=EOF);
	if (c == '[') {
	    term->u_tag[i] = 0;
	    term->arr[i].ae_t = PSF_MALLOC(struct ae_term);
	    read_ae_term(term->arr[i].ae_t);
	} else {
	    term->u_tag[i] = 1;
	    term->arr[i].s_t = PSF_MALLOC(struct s_term);
	    read_s_term(term->arr[i].s_t);
	}
    }
    read_char(')');
}

void read_process_expr(p_expr)
    struct process_expr *p_expr;
{
    char c;
    int i;
    arity arg;

    skip_space();
    c = getc(input);
    PSF_ASSERT(ungetc(c, input)!=EOF);
    if (c == '[') {
	p_expr->fun = AET;
	read_ae_term(&p_expr->proc_expr.pe2);
    } else {
	read_char('<');
	skip_space();
	c = p_expr->fun = getc(input);
	linepos++;

#ifdef READDEBUG
	fprintf(stderr, "%c", c);
#endif

	switch (c) {
	case ALT:
	case SEQ:
	case PAR:
	case INTR:
	case DISR:
	case STAR:
	case SHARP:
	    read_char(',');
	    arg = read_nat();
	    read_char('>');
	    read_char('(');
	    p_expr->proc_expr.pe3.a = arg;

	    p_expr->proc_expr.pe3.pe =
		PSF_NMALLOC(struct process_expr, arg);
	    for (i = 0; i < arg; i++)
		read_process_expr(&p_expr->
				  proc_expr.pe3.pe[i]);
	    read_char(')');

	    break;
	case SKP:
	case DLK:
	    read_char('>');
	    break;
	case SUM:
	case MRG:
	case ENC:
	case HID:
	    read_char('>');
	    read_char('(');
	    read_index(&p_expr->proc_expr.pe1.ind);
	    p_expr->proc_expr.pe1.pe = PSF_MALLOC(struct process_expr);
	    read_process_expr(p_expr->proc_expr.pe1.pe);
	    read_char(')');
	    break;

#ifndef NOIF
	case IF:
	    read_char('>');
	    read_char('(');
	    read_ae_term(&p_expr->proc_expr.pe4.aex);
	    read_ae_term(&p_expr->proc_expr.pe4.aey);
	    p_expr->proc_expr.pe4.pe = PSF_MALLOC(struct process_expr);
	    read_process_expr(p_expr->proc_expr.pe4.pe);
	    read_char(')');
	    break;
#endif				/* NOIF */

	case PRIO:
	    read_char('>');
	    read_char('(');
	    read_indexlist(&p_expr->proc_expr.pe5.sets);
	    p_expr->proc_expr.pe5.pe = PSF_MALLOC(struct process_expr);
	    read_process_expr(p_expr->proc_expr.pe5.pe);
	    read_char(')');
	    break;

	default:
	    assert(0);		/* should not occur */
	}
    }
}

void read_par_tuple(par_t)
    par_tuple *par_t;
{
    par_t->t = read_tag();
    read_indexlist(&par_t->par_attr);
    par_t->ff = read_freeformat();
}

void read_ren_tuple(ren_t)
    ren_tuple *ren_t;
{
    read_index(&ren_t->ind1);
    read_index(&ren_t->ind2);
    ren_t->ff = read_freeformat();
}

void read_bin_tuple(bin_t)
    bin_tuple *bin_t;
{
    read_index(&bin_t->par_ind);
    read_index(&bin_t->mod_ind);
    read_indexlist(&bin_t->ren_indlist);
    bin_t->ff = read_freeformat();
}

void read_imp_tuple(imp_t)
    imp_tuple *imp_t;
{
    read_index(&imp_t->mod_ind);
    imp_t->t = read_tag();
    read_indexlist(&imp_t->bin_indlist);
    read_indexlist(&imp_t->ren_indlist);
    imp_t->ff = read_freeformat();
}

void read_sor_tuple(sor_t)
    sor_tuple *sor_t;
{
    sor_t->t = read_tag();
    sor_t->ff = read_freeformat();
}

void read_fun_tuple(fun_t)
    fun_tuple *fun_t;
{
    fun_t->t = read_tag();
    read_indexlist(&fun_t->sor_indlist);
    read_indexlist(&fun_t->return_list);
    fun_t->ff = read_freeformat();
}

void read_atm_tuple(atm_t)
    atm_tuple *atm_t;
{
    atm_t->t = read_tag();
    read_indexlist(&atm_t->sor_indlist);
    atm_t->ff = read_freeformat();
}

void read_pro_tuple(pro_t)
    pro_tuple *pro_t;
{
    read_atm_tuple(pro_t);
}

void read_set_tuple(set_t)
    set_tuple *set_t;
{
    char c;

    set_t->t = read_tag();
    read_index(&set_t->ind);

    set_t->u_tag = -1;
#ifdef THIS_IS_ITIL_TIL
    if (set_t->t != IMPORTS && set_t->t != PARAMETER) {
#else
    if (set_t->t != IMPORTS && set_t->t != PARAMETER) {
#endif

	skip_space();
	c = getc(input);
	PSF_ASSERT(ungetc(c, input)!=EOF);
	if (c == '[') {
	    set_t->u_tag = 0;
	    read_index(&set_t->construct.sort);
	} else {
	    set_t->u_tag = 1;
	    read_s_term(&set_t->construct.set_term);
	}
    }
    set_t->ff = read_freeformat();
}

void read_com_tuple(com_t)
    com_tuple *com_t;
{
    com_t->t = IDLE;
    read_ae_term(&com_t->aet[0]);
    read_ae_term(&com_t->aet[1]);
    read_ae_term(&com_t->aet[2]);
    com_t->ff = read_freeformat();
}

void read_var_tuple(var_t)
    var_tuple *var_t;
{
    var_t->t = read_tag();
    read_index(&var_t->ind);
    var_t->ff = read_freeformat();
}

void read_equ_tuple(equ_t)
    equ_tuple *equ_t;
{
    int i;
    int c;

    equ_t->t = IDLE;
    read_ae_term(&equ_t->aet1);
    read_char('=');
    read_ae_term(&equ_t->aet2);
    skip_space();
    c = getc(input);
    PSF_ASSERT(ungetc(c, input)!=EOF);
    if (c == '<') {
	read_char('<');
	read_char('=');
	equ_t->a = read_nat();
	equ_t->guard = PSF_NMALLOC(struct equation, equ_t->a);
	for (i = 0; i < equ_t->a; i++) {
	    read_ae_term(&equ_t->guard[i].aet1);
	    read_char('=');
	    read_ae_term(&equ_t->guard[i].aet2);
	    if (i < equ_t->a - 1)
		read_char(',');
	}
    } else
	equ_t->a = 0;
    equ_t->ff = read_freeformat();
}

void read_def_tuple(def_t)
    def_tuple *def_t;
{
    def_t->t = IDLE;
    read_ae_term(&def_t->ae_t);
    read_char('=');
    read_process_expr(&def_t->p_expr);
    def_t->ff = read_freeformat();
}

void read_mod_tuple(mod_t)
    mod_tuple *mod_t;
{
    mod_t->ff = read_freeformat();
}

void read_und_tuple(und_t)
    und_tuple *und_t;
{
    und_t->ff = read_freeformat();
}
