.TH "READXTIL" 3  "Sep 16, 1993" "PSF-Toolkit" ROUTINES
.SH NAME
readxtil, read_module \- scanner/parser for MTIL and ITIL
.SH OVERVIEW
Since several tools operate on MTIL/ITIL a readxtil is provided.
It comprises of several files which read MTIL/ITIL and create a data structure.
.SH SYNOPSIS
.nf
.ft B
#include "xtiltype.h"
#include "readxtil.h"

char *progname;
char *filename;

int read_module (mod, type, fp)
struct module *mod;
int type;
FILE *fp;
.fi
.ft R
.SH DESCRIPTION
.B read_module(\|) reads MTIL- or ITIL-code.
If
.I type
is 1 it reads MTIL, and
if it is 0 it reads ITIL.
The code is read from
.IR fp ,
and is put in
.IR mod .
.br
If an error is found in the input,
.B read_module(\|)
returns 1, otherwise it returns 0.
.LP
For the handling of malloc and syntax errors the
.B progname
and
.B filename
must be defined.
.SH FILES
.PD 0
.TP
.B .../src/include/readxtil/readexp.c
.TP
.B .../src/include/readxtil/readexp.h
.TP
.B .../src/include/readxtil/readxtil.c
.TP
.B .../src/include/readxtil/readxtil.h
.TP
.B .../src/include/readxtil/readxtiltype.c
.TP
.B .../src/include/readxtil/readxtiltype.h
.TP
.B .../src/include/readxtil/xtiltype.h
.TP
.B .../src/include/readxtil/readxtil.imake
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
