#ifndef PSF_STANDARDS_INCLUDED
#define PSF_STANDARDS_INCLUDED
#include <stdio.h>
#include <stdlib.h>
#include "psf_redefs.h"
#include "psf_exits.h"
typedef int bool;

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef THIS_CANNOT_HAPPEN
#define THIS_CANNOT_HAPPEN 0
#endif

#ifndef UNDEFINED
#define UNDEFINED -1
#endif

#ifndef __DATE__

#ifdef  DATE
#define __DATE__ DATE
#else
#define __DATE__ "one dark day"
#endif				/* DATE */

#endif				/* __DATE__ */

#ifndef TOOLKITVERSION
#define TOOLKITVERSION "version number not retrieved at compilation"
#endif

/* psf_standards.c */
extern char *psf_basename PROTO_ARGS((char *s));


#ifdef __STDC__
#define the_str(s)  #s
#else
#define the_str(s) "s"
#endif				/* __STDC__ */

extern char *progname;

#ifndef TOOLKIT_FAULT
#define TOOLKIT_FAULT\
            (void) fprintf(stderr,"\n%s%s%s%s%s%s (%s).\n",             \
                "This is probably an error in the PSF-Toolkit. ",       \
                "Please report this by\nsending e-mail to ",            \
                "psf-bugs@win.tue.nl, containing the psf (mcrl) ",      \
                "sources,\nthe command with which caused ",             \
                "this error message and the version number\n",          \
                "of the PSF-Toolkit",                                   \
                TOOLKITVERSION)
#endif /* TOOLKIT_FAULT */

#ifndef PSF_ASSERT
#define PSF_ASSERT(the_assertion)					\
do {									\
    if (!(the_assertion)) {						\
	    (void) fprintf(stderr, "%s: assertion failed (%s)", 	\
			   progname, the_str(the_assertion));		\
		(void) fprintf(stderr," file %s, line %i\n",		\
				__FILE__,__LINE__);			\
                TOOLKIT_FAULT;						\
		exit(EXIT_HELP);					\
	} 								\
} while (0)
#endif				/* PSF_ASSERT */

#endif				/* PSF_STANDARDS_INCLUDED */
