.TH "psf_malloc" 3  "Sep. 16, 1993" "PSF-Toolkit"
.SH NAME psf_malloc - shell around malloc to check on correct return arguments.
 
.SH psf_malloc

.SH OVERVIEW
.nf
#include "psf_malloc.h"

contained macros:
	PSF_MALLOC( type)
	PSF_NMALLOC( type, number)
	PSF_REALLOC(ptr,type, number)
	PSF_FREE(ptr)
contained functions:
	char * psf_malloc(/* unsigned size */);
	char * psf_realloc(/* char * ptr, unsigned size */);
	char * psf_strdup(/* const char * */);
.fi
.SH DESCRIPTION

For the use of these macros the global variable (char *)progname , which should
be the name of the invoked program i.e. argv[0], must be defined.
If a call to malloc fails an error message is diplayed and an
exit(EXIT_MEM_ERR) is done.
The macros contain all typecasting which is needed to use the functions,
except for psf_strdup, which is equal to strdup except for a check on the
failing of strdup and giving an appropriate error message and exit.
.SH FILES
psf_malloc.c psf_malloc.h psf_malloc.imake
.SH DIAGNOSTICS
.SH BUGS
.SH SEE ALSO

