#include <stdlib.h>		/* for size_t */

/* psf_malloc.c */
extern char *psf_malloc PROTO_ARGS((size_t size));
extern char *psf_realloc PROTO_ARGS((char *ptr, size_t size));
extern char *psf_strdup PROTO_ARGS((char *str));

extern char *progname;

#ifdef lint
#define PSF_MALLOC(type)		\
	((void)psf_malloc (sizeof (type)), (type *)0)
#define PSF_NMALLOC(type, n)		\
	((void)psf_malloc ((size_t) (n) * sizeof (type)), (type *)0)
#define PSF_REALLOC(ptr, type, n)	\
	((void)psf_realloc ((char *) (ptr), (size_t) (n) * sizeof (type)), (type *)0)
#define PSF_FREE(ptr)			\
	free((char *)ptr)
#else	/* lint */
#define PSF_MALLOC(type)		\
	((type *) psf_malloc (sizeof (type)))
#define PSF_NMALLOC(type, n)		\
	((type *) psf_malloc ((size_t) (n) * sizeof (type)))
#define PSF_REALLOC(ptr, type, n)	\
	((type *) psf_realloc ((char *) (ptr), (size_t) (n) * sizeof (type)))
#define PSF_FREE(ptr)			\
	free((char *)ptr)
#endif	/* lint */
