#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_exits.h"
#include "psf_standards.h"

/*
 * In ANSI C, size_t is unsigned, which makes sense. In Sun C, size_t is
 * signed, but malloc wants an unsigned anyway. The following macro tries to
 * kludge around Sun's problems.
 */

extern char * progname;

#if sun && !(__STDC__-0)
#define GRRR (unsigned)
#else
#define GRRR
#endif

char *psf_malloc(size)
    size_t size;
{
    char *ptr;

    if ((ptr = malloc(GRRR(size_t) size)) == NULL) {
	(void) fprintf(stderr, "%s: out of memory\n", progname);
	exit(EXIT_MEM_ERR);
    }
    return (ptr);
}

char *psf_realloc(ptr, size)
    char *ptr;
    size_t size;
{
    if (ptr == NULL)		/* realloc() should do this, */
	return psf_malloc(size);/* but the SunOS version doesn't */
    if ((ptr = realloc(ptr, GRRR(size_t) size)) == NULL) {
	(void) fprintf(stderr, "%s: out of memory\n", progname);
	exit(EXIT_MEM_ERR);
    }
    return (ptr);
}

char *psf_strdup(str)
    char *str;
{
    char *s;

    if (str == NULL) {
	(void) fprintf(stderr, "%s: 'NULL' is not a string\n", progname);
    }
    if ((s = strdup(str)) == NULL) {
	(void) fprintf(stderr, "%s: out of memory\n", progname);
	exit(EXIT_MEM_ERR);
    }
    return (s);
}
