.TH "psf_fopen" 3  "Sep. 16, 1993" "PSF-Toolkit"
.SH NAME includes - description of the interfaces to the include files from the psf toolkit.
 
.SH psf_fopen
.SH OVERVIEW
.nf
$include "psf_fopen.h"

contained types
	suffix
	psf_file
contained functions
	psf_file psf_fopen( /* char * name , suffix *s */ );
.fi
.SH DESCRIPTION
The function psf_fopen opens a file for reading using the protocol 
described in \fBprogramming.style\fR.

The type suffix is a struct with members (char *)env and (char *)suf.
The type psf_file is a struct with members (FILE *)fp and (char *)name.
The function psf_fopen opens a file for reading with name 'name' and an
optional suffix from suffix[].
The file with name 'name' is first tried to be opened, if this fails with
a file does not excist, the suffixes are tried. 
The env part of a suffix is the name of an environment variable possibly
containing the suffix. If this environment variable is not defined in the
environment, the suf part is used as suffix.
If no file can be opened an error message is diplayed and an
exit(EXIT_IO_ERR) takes place. 
If both members of an suffix of the suffix array are NULL, that member is
considered to be the last.
If the array itself is NULL, it is asumed there are no suffixes, this
avoid the need to define an array { {NULL,NULL}}, 
Also psf_fopen requires (char *)progname to be defined since it is used
in the error messages.
.SH SKELETON
.nf
psf_file *pf;
static suffix suffixes[]={ { "PSFSUFFIX" ,".psf" }, {NULL, NULL} };
static suffix suffixes[]=NULL;
char *name="Hello";

    pf=psf_fopen(name,suffixes);
.fi
.SH FILES
psf_fopen.h psf_fopen.c psf_malloc.h psf_malloc.c psf_fopen.imake
.SH DIAGNOSTICS
.SH BUGS
.SH SEE ALSO 

