#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "psf_prototype.h"
#include "psf_exits.h"
#include "psf_fopen.h"
#include "psf_malloc.h"
#include "psf_redefs.h"

void check_dir(pf)
    psf_file pf;
{
    struct stat buf;

    if (fstat(fileno(pf.fp), &buf) == 0 ) {
	if (S_ISDIR(buf.st_mode)) {
	    (void) fprintf(stderr, "%s: %s is a directory\n",
			   progname, pf.name);
	    exit(EXIT_IO_ERR);
	}
    } else {
	(void) fprintf(stderr, "%s: could not stat ",
		       progname);
	perror(pf.name);
	exit(EXIT_IO_ERR);
    }
}

psf_file psf_fopen(name, suffixes)
    char *name;
    suffix *suffixes;
{
    int i;
    psf_file pf;
    char *ext;

    if (name[0]=='\0') {
	(void) fprintf(stderr, "%s: \"empty\" is not a valid filename\n",
		       progname);
	exit(EXIT_IO_ERR);
    }
    if ((pf.fp = fopen(name, "r")) != NULL) {
	pf.name = name;
	check_dir(pf);
	return pf;
    }
    if (suffixes)
	for (i = 0; (suffixes[i].suf != NULL || suffixes[i].env != NULL)
		&& errno == ENOENT; i++) {
	    if (suffixes[i].env == NULL ||
		    (ext = getenv(suffixes[i].env)) == NULL)
		ext = suffixes[i].suf;
	    if (ext) {
		pf.name = PSF_NMALLOC(char, strlen(name) + strlen(ext) + 1);
		(void) strcpy(pf.name, name);
		(void) strcat(pf.name, ext);
		if ((pf.fp = fopen(pf.name, "r")) != NULL) {
		    check_dir(pf);
		    return pf;
		}
		PSF_FREE(pf.name);
	    }
	}

    (void) fprintf(stderr, "%s: can't open ", progname);
    perror(name);
    exit(EXIT_IO_ERR);
    return pf;
}
