#include <stdio.h>
#include "psf_prototype.h"
#include "psf_standards.h"
#include "tiltype.h"
#include "prtilparts.h"
#include "prtilpsf.h"

static bool data = TRUE, process = TRUE;

void print_data_module(mod)
    struct module *mod;
{
    print_exp_section(mod);
    print_var_section(mod->entries_table[VAR], mod->var, 'd');
    print_equ_section(mod->entries_table[EQU], mod->equ);
}

void print_process_module(mod, output)
    struct module *mod;
    FILE *output;
{
    /*
     * print_par_section (mod -> entries_table[PRM], mod -> par);
     */
    if (data)
	(void) fprintf(output, "imports\n\t%s-data\n\n", mod->name);
    print_atm_section(mod->entries_table[ATM], mod->atm);
    print_pro_section(mod->entries_table[PRO], mod->pro);
    print_set_section(mod->entries_table[SET], mod->set);
    print_com_section(mod->entries_table[COM], mod->com);
    print_var_section(mod->entries_table[VAR], mod->var, 'p');
    print_def_section(mod->entries_table[DEF], mod->def);
}

void print_module(mod, output)
    struct module *mod;
    FILE *output;
{
    set_print_current_module(mod);
    set_print_output_file(output);
    mark_placeholders(mod);
    data = mod->entries_table[SOR] || mod->entries_table[FUN];
    process = mod->entries_table[ATM] || mod->entries_table[PRO] ||
	mod->entries_table[SET];

    if (data) {
	(void) fprintf(output, "data module %s%s\nbegin\n\n", mod->name,
		       process ? "-data" : "");
	print_data_module(mod);
	(void) fprintf(output, "end %s%s\n\n", mod->name,
		       process ? "-data" : "");
    }
    if (process) {
	(void) fprintf(output, "process module %s%s\nbegin\n\n",
		       mod->name, data ? "-process" : "");
	print_process_module(mod, output);
	(void) fprintf(output, "end %s%s\n\n", mod->name,
		       data ? "-process" : "");
    }
}
