%{
/* #include <stdio.h>   -- already included by lex; makedepend objects to
			-- including it twice */
#include <string.h>
#ifdef	OWNSCANIO
#include OWNSCANIO
#endif
#include "psf_prototype.h"
#include "scanterm.h"
#include "y.tab.h"
#include "psf_malloc.h"

static void set_yylval PROTO_ARGS((void));
static int chars = 0;
%}

id_char		[A-Za-z0-9\']
op_symbol	[!@$%\^&+\-*;?~/|\\]
ident		{id_char}(({id_char}|-)*{id_char})?
operator	({op_symbol}+)|(\.{ident}\.)

%%
{ident} {
		scan_error_str (yytext, yyleng);
		set_yylval ();
		chars += yyleng;
		return (IDENTIFIER);
	}
{operator} {
		scan_error_str (yytext, yyleng);
		set_yylval ();
		chars += yyleng;
		return (OPERATOR);
	}
"("	{ scan_error_str (yytext, yyleng); chars += yyleng; return (LH); }
")"	{ scan_error_str (yytext, yyleng); chars += yyleng; return (RH); }
","	{ scan_error_str (yytext, yyleng); chars += yyleng; return (COMMA); }
">"	{ scan_error_str (yytext, yyleng); chars += yyleng; return (TRSSET); }
[ \t]	chars += yyleng;
[\f\r\n]	{ chars += yyleng; return (NEWLINE); }
\.	{ scan_error_str (yytext, yyleng); chars += yyleng; return (SEP); }
.	{ chars += yyleng; return (yytext[0]); }

%%
int	yywrap ()
{
	/* to handle EOF when input is redirected */
	exit (0);
}

static void	set_yylval ()
{
	yylval.literal = psf_strdup(yytext);
}

static	char	* pstr;
static	int	max_ind = 0;
static	int	ind = 0;

void	scan_error_str (s, l)
char	* s;
int	l;
{
	if (ind + l >= max_ind) {
		if (max_ind == 0) {
			max_ind = 1024;
			pstr = PSF_NMALLOC(char, max_ind );
		} else {
			max_ind += 1024;
			pstr = PSF_REALLOC(pstr, char, max_ind);
		}
	}
	sprintf (& pstr[ind], "%s ", s);
	ind += l + 1;
}

void	print_scan_error_str ()
{
	pstr[ind] = '\0';
	fprintf (stderr, "%s\n", pstr);
	ind = 0;
}

void	reset_scan_error_str ()
{
	ind = 0;
}

static	int	save_chars;

void	scan_save_chars ()
{
	save_chars = chars;
}

int	scan_get_chars ()
{
	return (save_chars);
}

void	scan_reset_chars ()
{
	chars = 0;
}
