#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "tiltype.h"
#include "fieldex.h"

static struct module *mod;

ae_term *make_binary_node(key)
    keytype key;
{
    ae_term *ae_t;

    ae_t = PSF_MALLOC(ae_term);
    ae_t->t = TERM;
    ae_t->ind.table = FUN;
    ae_t->ind.key = key;
    ae_t->a = 2;
    ae_t->ae_list = PSF_NMALLOC(ae_term, 2);
    return (ae_t);
}

ae_term *make_unary_node(key)
    keytype key;
{
    ae_term *ae_t;

    ae_t = PSF_MALLOC(ae_term);
    ae_t->t = TERM;
    ae_t->ind.table = FUN;
    ae_t->ind.key = key;
    ae_t->a = 1;
    ae_t->ae_list = PSF_MALLOC(ae_term);
    return (ae_t);
}

ae_term *make_var_node(key)
    keytype key;
{
    ae_term *ae_t;

    ae_t = PSF_MALLOC(ae_term);
    ae_t->t = TERM;
    ae_t->ind.table = VAR;
    ae_t->ind.key = key;
    ae_t->a = 0;
    ae_t->ae_list = NULL;
    return (ae_t);
}

ae_term *make_fun_node(key)
    keytype key;
{
    ae_term *ae_t;

    ae_t = PSF_MALLOC(ae_term);
    ae_t->t = TERM;
    ae_t->ind.table = FUN;
    ae_t->ind.key = key;
    ae_t->a = 0;
    ae_t->ae_list = NULL;
    return (ae_t);
}

void copy_node(p, c, i)
    ae_term *p;
    ae_term *c;
    arity i;
{
    p->ae_list[i] = *c;
    free(c);
}

int arg_fun(key)
    keytype key;
{
    return (mod->fun[key].sor_indlist.a);
}

/* stack defintion and routines */

static ae_term **stack;
static int stack_count;
static int max_count = 16;

static void init_stack()
{
    stack = PSF_NMALLOC(ae_term *, max_count);
    stack_count = -1;
}

void push_list(ae_t)
    ae_term *ae_t;
{
    stack_count++;
    if (stack_count == max_count) {
	max_count += 4;
	stack = PSF_REALLOC(stack, ae_term *, max_count);
    }
    stack[stack_count] = ae_t;
}

ae_term *pop_list()
{
    ae_term *ae_l;

    ae_l = stack[stack_count];
    stack_count--;
    return (ae_l);
}

void copy_to_list(ae_t)
    ae_term *ae_t;
{
    ae_term *ae_l;

    ae_l = stack[stack_count];
    ae_l->a++;
    if (ae_l->a == 1)
	ae_l->ae_list = PSF_MALLOC(ae_term);
    else
	ae_l->ae_list = PSF_REALLOC(ae_l->ae_list, ae_term, ae_l->a);
    copy_node(ae_l, ae_t, ae_l->a - 1);
}

/* function, variable, and module tables definition and routines */

static char **fun_name;
static int nr_fun;
static int *fun_o;
static char **var_name;
static int nr_var;
static int *var_o;
static char **mod_name;
static int nr_mod;

static void init_tables()
{
    char *s;
    int i;
    int nr_adm;
    int m;

    nr_fun = mod->entries_table[FUN];
    fun_name = PSF_NMALLOC(char *, nr_fun + 1);
    fun_o = PSF_NMALLOC(int, nr_fun + 1);
    for (i = 1; i <= nr_fun; i++) {
	s = field_extract("n", mod->fun[i].ff,FUN,i);
	fun_name[i] = psf_strdup(s);
	s = field_extract("o", mod->fun[i].ff,FUN,i);
	if (sscanf(s, "%d", &fun_o[i])!=1) fun_o[i]=0;
    }
    nr_var = mod->entries_table[VAR];
    var_name = PSF_NMALLOC(char *, nr_var + 1);
    var_o = PSF_NMALLOC(int, nr_var + 1);
    for (i = 1; i <= nr_var; i++) {
	s = field_extract("n", mod->var[i].ff,VAR,i);
	var_name[i] = psf_strdup(s);
	s = field_extract("o", mod->var[i].ff,VAR,i);
	if(sscanf(s, "%d", &var_o[i])!=1) var_o[i]=0;;
    }
    nr_adm = mod->entries_table[ADM];
    mod_name = NULL;
    nr_mod = 0;
    for (i = 1; i <= nr_adm; i++) {
	s = field_extract("m", mod->adm[i].ff,ADM,i);
	if (s == NULL)
	    continue;
	if (sscanf(s, "%u", &m)!=1) m = 0;
	if (m > nr_mod) {
	    if (mod_name == NULL) {
		mod_name = PSF_NMALLOC(char *, m + 1);
	    } else {
		mod_name = PSF_REALLOC(mod_name, char *, m + 1);
	    }
	    nr_mod = m;
	}
	while (*(s++) != ' ' && *s!='\0');
	mod_name[m] = psf_strdup(s);
    }
}

void free_tables()
{
    int i;

    for (i = 1; i <= nr_fun; i++)
	free(fun_name[i]);
    free(fun_name);
    for (i = 1; i <= nr_var; i++)
	free(var_name[i]);
    free(var_name);
    for (i = 1; i <= nr_mod; i++)
	free(mod_name[i]);
    free(mod_name);
}

keytype key_binary(mnr, name)
    int mnr;
    char **name;
{
    int i;
    char s[128];

    sprintf(s, "_%s_", *name);
    for (i = 1; i <= nr_fun; i++) {
	if (mnr && fun_o[i] != mnr)
	    continue;
	if (strcmp(s, fun_name[i]) == 0) {
	    *name = fun_name[i];
	    return (i);
	}
    }
    return (0);
}

keytype key_unary(mnr, name)
    int mnr;
    char **name;
{
    int i;
    char s[128];

    sprintf(s, "%s_", *name);
    for (i = 1; i <= nr_fun; i++) {
	if (mnr && fun_o[i] != mnr)
	    continue;
	if (strcmp(s, fun_name[i]) == 0) {
	    *name = fun_name[i];
	    return (i);
	}
    }
    return (0);
}

keytype key_next_fun(mnr, name, key)
    int mnr;
    char *name;
    keytype key;
{
    int i;

    for (i = key + 1; i <= nr_fun; i++) {
	if (mnr && fun_o[i] != mnr)
	    continue;
	if (strcmp(fun_name[i], name) == 0)
	    return (i);
    }
    return (0);
}

keytype key_fun(mnr, name)
    int mnr;
    char *name;
{
    return (key_next_fun(mnr, name, 0));
}

keytype key_next_var(mnr, name, key)
    int mnr;
    char *name;
    keytype key;
{
    int i;

    for (i = key + 1; i <= nr_var; i++) {
	if (mnr && var_o[i] != mnr)
	    continue;
	if (strcmp(var_name[i], name) == 0)
	    return (i);
    }
    return (0);
}

keytype key_var(mnr, name)
    int mnr;
    char *name;
{
    return (key_next_var(mnr, name, 0));
}

keytype key_module(name)
    char *name;
{
    int i;

    for (i = 1; i <= nr_mod; i++)
	if (strcmp(mod_name[i], name) == 0)
	    return (i);
    return (0);
}

void init_parse_util(m)
    struct module *m;
{
    mod = m;
    init_stack();
    init_tables();
}

int find_fun_node(mnr, ae_t, name)
    int mnr;
    ae_term *ae_t;
    char *name;
{
    int i;
    struct indexlist *indl;
    keytype key;

    while (1) {
	indl = &mod->fun[ae_t->ind.key].sor_indlist;
	if (indl->a == ae_t->a) {
	    for (i = 0; i < ae_t->a; i++) {
		if (ae_t->ae_list[i].ind.table == VAR) {
		    if (mod->var[ae_t->
				 ae_list[i].ind.key].ind.key !=
			    indl->indlist[i].key) {
			break;
		    }
		} else {
		    if (mod->fun[ae_t->ae_list[i].ind.key]
			    .return_list.indlist[0].key !=
			    indl->indlist[i].key) {
			break;
		    }
		}
	    }
	    if (i == ae_t->a)
		return (0);
	}
	if (key = key_next_fun(mnr, name, ae_t->ind.key))
	    ae_t->ind.key = key;
	else
	    return (1);
    }
}

int find_next_fun_node(mnr, ae_t, name)
    int mnr;
    ae_term *ae_t;
    char *name;
{
    keytype key, old;

    if (key = key_next_fun(mnr, name, ae_t->ind.key)) {
	old = ae_t->ind.key;
	ae_t->ind.key = key;
	if (find_fun_node(mnr, ae_t, name)) {
	    ae_t->ind.key = old;
	    return (1);
	} else
	    return (0);
    } else
	return (1);
}
