%{
#include <stdio.h>
#include <string.h>
#include "psf_prototype.h"
#include "tiltype.h"
#include "parsetermutil.h"
#include "parsetermerror.h"
#include "scanterm.h"		/* for reset_scan_error_str() */
#include "eqm.h"
#include "psf_malloc.h"
struct ae_term * Parseterm_Aet;
int Parseterm_status;

static void yyerror PROTO_ARGS((char *));
%}

%start	AET_term

%union {
	char	* literal;
	struct	ae_term	* ae_t;
	struct	complex {
		int	mod_nr;
		char	* mod_name;
		char	* id_name;
	}	* ident;
}

%token	<literal>	IDENTIFIER
%token	<literal>	OPERATOR
%token			LH
%token			RH
%token			COMMA
%token			NEWLINE
%token			TRSSET
%token			SEP

%type	<ae_t>		term
%type	<ae_t>		primary
%type	<ae_t>		term_list
%type	<ident>		complex_operator
%type	<ident>		complex_identifier

%%
AET_term :
	NEWLINE {
		Parseterm_Aet = NULL;
		Parseterm_status = 0;
		reset_scan_error_str ();
		YYACCEPT;
	}
|	term {
		Parseterm_Aet = $1;
	}
	NEWLINE {
		Parseterm_status = 0;
		reset_scan_error_str ();
		YYACCEPT;
	}
|	TRSSET IDENTIFIER IDENTIFIER NEWLINE {
		Parseterm_Aet = NULL;
		Parseterm_status = -1;
		if (strcmp ($2, "trace")) {
			parseterm_error ("unknown option '%s'\n", $2);
			Parseterm_status = 1;
			YYACCEPT;
		}
#ifdef TERMTRACE
		if (! strcmp ($3, "on")) {
			term_trace = 1;
			printf ("Trace on\n");
			YYACCEPT;
		}
		if (! strcmp ($3, "off")) {
			term_trace = 0;
			printf ("Trace off\n");
			YYACCEPT;
		}
		parseterm_error ("invalid value '%s' for option '%s'\n",
		    $3, $2);
		parseterm_error ("use one of the following: on off");
#else
		parseterm_error ("Sorry, the trace option is not available.\n");
		parseterm_error ("If you need it, you'll have to recompile ");
		parseterm_error ("the program with TERMTRACE defined\n");
#endif
		reset_scan_error_str ();
		Parseterm_status = 1;
		YYACCEPT;
	}
|	error {
		scan_save_chars ();
		scan_error_str ("???", 3);
	} NEWLINE {
		yyerrok;
		yyclearin;
		Parseterm_Aet = NULL;
		Parseterm_status = 1;
		YYACCEPT;
	}
;

term :
	primary {
		$$ = $1;
	}
|	term complex_operator {
		keytype	key;

		if (key = key_binary ($2 -> mod_nr, & $2 -> id_name)) {
			$<ae_t>$ = make_binary_node (key);
			copy_node ($<ae_t>$, $1, 0);
		} else {
			if ($2 -> mod_nr)
				parseterm_error ("%s.%s not a binary operator\n"
					, $2 -> id_name, $2 -> mod_name);
			else
				parseterm_error ("%s not a binary operator\n",
					$2 -> id_name);
			YYERROR;
		}
	}
	primary {
		$$ = $<ae_t>3;
		copy_node ($$, $4, 1);
		if (find_fun_node ($2 -> mod_nr, $$, $2 -> id_name)) {
			parseterm_error ("wrong type of operands with binary \
operator %s\n", $2 -> id_name);
			YYERROR;
		} else {
			if (find_next_fun_node ($2 -> mod_nr, $$, $2 ->
				id_name) == 0) {
				parseterm_error ("An origin module for \
binary operator %s must be given\n", $2 -> id_name);
				YYERROR;
			}
		}
	}
;

primary :
	complex_identifier {
		keytype	key;

		if (key = key_fun ($1 -> mod_nr, $1 -> id_name)) {
			$$ = make_fun_node (key);
			if (find_fun_node ($1 -> mod_nr, $$, $1 -> id_name)
				== 0) {
				if (find_next_fun_node ($1 -> mod_nr, $$, $1 ->
					id_name) == 0) {
					parseterm_error ("An origin module for\
 function %s must be given\n", $1 -> id_name);
					YYERROR;
				}
				if (key_var ($1 -> mod_nr, $1 -> id_name)) {
					parseterm_error ("%s may be a \
function or a variable\n", $1 -> id_name);
					YYERROR;
				}
			break;
		}
	}
	if (key = key_var ($1 -> mod_nr, $1 -> id_name)) {
		      $$ = make_var_node (key);
		      if (key = key_next_var ($1 -> mod_nr, $1 ->
			      id_name, key)) {
			      parseterm_error ("An origin module for \
variable %s must be given\n", $1 -> id_name);
			      YYERROR;
		      }
	} else {
		if ($1 -> mod_nr)
			parseterm_error ("unknown identifier %s.%s\n",
				$1 -> mod_name, $1 -> id_name);
		else
			parseterm_error ("unknown identifier %s\n",
				$1 -> id_name);
		YYERROR;
	}
}
|	complex_identifier LH {
	keytype	key;

		if (key = key_fun ($1 -> mod_nr, $1 -> id_name)) {
			$<ae_t>$ = make_fun_node (key);
			push_list ($<ae_t>$);
		} else {
			if ($1 -> mod_nr)
				parseterm_error ("%s.%s not a function\n",
					$1 -> id_name, $1 -> mod_name);
			else
				parseterm_error ("%s not a function\n",
					$1 -> id_name);
			YYERROR;
		}
	}
	term_list RH {
		$$ = pop_list ();
		if (find_fun_node ($1 -> mod_nr, $$, $1 -> id_name)) {
			parseterm_error ("invalid arguments for function %s\n",
				$1 -> id_name);
			YYERROR;
		}
		if (find_next_fun_node ($1 -> mod_nr, $$, $1 -> id_name)
			== 0) {
			parseterm_error ("An origin module for function %s \
must be given\n", $1 -> id_name);
			YYERROR;
		}
	}
|	complex_operator {
		keytype	key;

		if (key = key_unary ($1 -> mod_nr, & $1 -> id_name))
			$<ae_t>$ = make_unary_node (key);
		else {
			if ($1 -> mod_nr)
				parseterm_error ("%s.%s not a unary operator\n",
					$1 -> id_name, $1 -> mod_name);
			else
				parseterm_error ("%s not a unary operator\n",
					$1 -> id_name);
			YYERROR;
		}
	}
	primary {
		$$ = $<ae_t>2;
		copy_node ($$, $3, 0);
		if (find_fun_node ($1 -> mod_nr, $$, $1 -> id_name)) {
			parseterm_error ("wrong type of operands with unary \
operator %s\n", $1 -> id_name);
			YYERROR;
		} else {
			if (find_next_fun_node ($1 -> mod_nr, $$, $1 ->
				id_name) == 0) {
				parseterm_error ("An origin module for \
unary operaotr %s must be given\n", $1 -> id_name);
				YYERROR;
			}
		}
	}
|	LH term RH {
		$$ = $2;
	}
;

term_list :
	term {
		copy_to_list ($1);
	}
|	term_list COMMA term {
		copy_to_list ($3);
	}
;

complex_operator :
	IDENTIFIER SEP OPERATOR {
		$$ = PSF_MALLOC(struct complex ) ;
		if (($$ -> mod_nr = key_module ($1)) == 0) {
			parseterm_error ("%s not a module\n", $1);
			YYERROR;
		}
		$$ -> mod_name = $1;
		$$ -> id_name = $3;
	}
|	OPERATOR {
		$$ = PSF_MALLOC(struct complex );
		$$ -> mod_nr = 0;
		$$ -> mod_name = NULL;
		$$ -> id_name = $1;
	}
;

complex_identifier :
	IDENTIFIER SEP IDENTIFIER {
		$$ = PSF_MALLOC(struct complex ) ;
		if (($$ -> mod_nr = key_module ($1)) == 0) {
			parseterm_error ("%s not a module\n", $1);
			YYERROR;
		}
		$$ -> mod_name = $1;
		$$ -> id_name = $3;
	}
|	IDENTIFIER {
		$$ = PSF_MALLOC(struct complex) ;
		$$ -> mod_nr = 0;
		$$ -> mod_name = NULL;
		$$ -> id_name = $1;
	}
;
%%

static	void	yyerror (s)
char	* s;
{
	parseterm_error ("%s\n", s);
}
