.TH "PARSETERM" 3  "Dec 22, 1993" "PSF-Toolkit" ROUTINES
.SH NAME
parseterm, yyparse, init_parse_util, get_parseterm_error, print_scan_error_str,
scan_reset_chars, scan_get_chars \- routines for parsing PSF-terms
.SH SYNOPSIS 
.nf
.ft B
#include "parseterm.h"

int Parseterm_Allowvar;
struct ae_term *Parseterm_aet;
int Parseterm_status;
.LP
.ft B
int yyparse ()
.LP
.ft B
#include "parsetermutil.h"

void init_parse_util (mod)
struct module *mod;
.LP
.ft B
#include "parsetermerror.h"

char *get_parseterm_error ()
.LP
.ft B
#include "scanterm.h"

void print_scan_error_str ()

void scan_reset_chars ()

int scan_get_chars ()
.fi
.ft R
.SH DESCRIPTION
.B yyparse(\|)
parses PSF-terms, and leaves the result in
.BR Parseterm_Aet .
If an error occurs from which
.B yyparse(\|)
cannot recover (should not be the case), it returns 1, otherwise 0.
But if a correct '>' is given it returns -1.
If
.B Parseterm_Aet
is NULL then either an empty-line is found, in which case
.B Parseterm_status
equals 0, or an '>' command is given
.RB ( Parseterm_status
is -1), or an error has occured
.RB (Parseterm_status
equals 1).
In the latter case, the error can be fetched with the use of
.BR get_parseterm_error(\|) .
.LP
.B init_parse_util(\|)
should be called before
.BR yyparse(\|) ,
because it initializes the parser with the TIL-code from
.IR mod .
.LP
.B get_parseterm_error(\|) returns the error-string.
.LP
.B print_scan_error_str(\|)
prints on stderr the the part of the term that has
been succesfully parsed followed by ??? and the rest of the term.
.LP
.B scan_reset_chars(\|)
sets the number of chars scanned to 0.
.LP
.B scan_get_chars(\|)
returns the number of chars scanned before an error
occured.
It can be used to locate the error in the term.
.SH SKELETON
.SH FILES
.PD 0
.TP
.B .../src/include/parseterm/parseterm.y
.TP
.B .../src/include/parseterm/parseterm.h
.TP
.B .../src/include/parseterm/scanterm.l
.TP
.B .../src/include/parseterm/scanterm.h
.TP
.B .../src/include/parseterm/parsetermutil.c
.TP
.B .../src/include/parseterm/parsetermutil.h
.TP
.B .../src/include/parseterm/parsetermerror.c
.TP
.B .../src/include/parseterm/parsetermerror.h
.SH AUTHOR
Bob Diertens, University of Amsterdam (bobd@fwi.uva.nl)
