/*****************************************************************\
*                                                                 *
*   type definitions for the M_TIL code                           *
*                                                                 *
\*****************************************************************/

#ifndef XTILTYPE_H_INCLUDED
#define XTILTYPE_H_INCLUDED

typedef unsigned int origintype;
typedef unsigned int tabletype;
typedef int keytype;

/* -1 should be used for ? */

struct indextype {
    origintype origin;
    tabletype table;
    keytype key;
};

typedef char tag;

#define	IDLE		'_'
#define	IMPORTS		'?'
#define	EXPORTS		'!'
#define PARAMETER	'@'
#define	LOCAL		'#'
#define UNKNOWN		'$'

typedef unsigned int arity;

struct indexlist {
    arity a;
    struct indextype *indlist;
};

typedef char *freeformat;

struct par_tuple {
    tag t;
    struct indexlist par_attr;
    freeformat ff;
    origintype o;
    keytype k;
};

struct ren_tuple {
    struct indextype ind1;
    struct indextype ind2;
    freeformat ff;
};

struct bin_tuple {
    struct indextype par_ind;
    struct indextype mod_ind;
    struct indexlist ren_indlist;
    freeformat ff;
};

#define	RENBIN		'R'
#define	BINREN		'B'
#define	NBINNREN	'*'

struct imp_tuple {
    struct indextype mod_ind;
    tag t;
    struct indexlist bin_indlist;
    struct indexlist ren_indlist;
    freeformat ff;
};

struct sor_tuple {
    tag t;
    freeformat ff;
    origintype o;
    keytype k;
};

struct fun_tuple {
    tag t;
    struct indexlist sor_indlist;
    struct indexlist return_list;
    freeformat ff;
    origintype o;
    keytype k;
};

struct atm_tuple {
    tag t;
    struct indexlist sor_indlist;
    freeformat ff;
    origintype o;
    keytype k;
};

#define	TUPLE	'<'
#define TERM	'['

struct ae_term {
    tag t;
    struct indextype ind;
    arity a;
    struct ae_term *ae_list;
};

struct s_term {
    char fun;
    arity a;
    int *u_tag;
    /*
     * 0		ae_term; 1		s_term;
     */
    union terms {
	struct ae_term *ae_t;
	struct s_term *s_t;
    } *arr;
};

#define	UNI		'+'
#define INT		'.'
#define DIF		'\\'
#define	ENU		':'

struct set_tuple {
    tag t;
    struct indextype ind;
    int u_tag;
    /*
     * 0		sort; 1		s_term;
     */
    union construction {
	struct indextype sort;
	struct s_term set_term;
    } construct;
    freeformat ff;
    origintype o;
    keytype k;
};

struct com_tuple {
    tag t;
    struct ae_term aet[3];
    freeformat ff;
    origintype o;
    keytype k;
};

struct var_tuple {
    tag t;
    struct indextype ind;
    freeformat ff;
    origintype o;
    keytype k;
};

struct equation {
    struct ae_term aet1;
    struct ae_term aet2;
};

struct equ_tuple {
    tag t;
    struct ae_term aet1;
    struct ae_term aet2;
    arity a;
    struct equation *guard;
    freeformat ff;
    origintype o;
    keytype k;
};

struct process_expr {
    char fun;
    union {
	struct {
	    struct indextype ind;
	    struct process_expr *pe;
	} pe1;
	struct ae_term pe2;
	struct {
	    arity a;
	    struct process_expr *pe;
	} pe3;

#ifndef NOIF
	struct {
	    struct ae_term aex;
	    struct ae_term aey;
	    struct process_expr *pe;
	} pe4;
#endif
	struct {
	    struct indexlist sets;
	    struct process_expr *pe;
	} pe5; /* PRIO */
    } proc_expr;
};

#define	AET		'\0'
#define SKP		'i'
#define DLK		'd'
#define	ALT		'a'
#define SEQ		's'
#define	PAR		'p'
#define	SUM		'A'
#define MRG		'P'
#define ENC		'e'
#define	HID		'h'

#ifndef NOIF
#define IF		'f'
#endif

#define INTR		'I'
#define DISR		'D'
#define PRIO		'R'
#define STAR		'K'
#define SHARP		'S'

struct def_tuple {
    tag t;
    struct ae_term ae_t;
    struct process_expr p_expr;
    freeformat ff;
    origintype o;
    keytype k;
};

struct mod_tuple {
    origintype o;
    freeformat ff;
};

struct und_tuple {
    freeformat ff;
};

struct adm_tuple {
    freeformat ff;
};

typedef struct adm_tuple adm_tuple;
typedef struct par_tuple par_tuple;
typedef struct ren_tuple ren_tuple;
typedef struct bin_tuple bin_tuple;
typedef struct imp_tuple imp_tuple;
typedef struct sor_tuple sor_tuple;
typedef struct fun_tuple fun_tuple;
typedef struct atm_tuple atm_tuple;
typedef struct atm_tuple pro_tuple;
typedef struct set_tuple set_tuple;
typedef struct com_tuple com_tuple;
typedef struct var_tuple var_tuple;
typedef struct equ_tuple equ_tuple;
typedef struct def_tuple def_tuple;
typedef struct mod_tuple mod_tuple;
typedef struct und_tuple und_tuple;

#define	MTABLE		16

struct module {
    char *name;
    origintype origin;
    freeformat ff;
    unsigned int entries_table[MTABLE];
    adm_tuple *adm;
    par_tuple *par;
    ren_tuple *ren;
    bin_tuple *bin;
    imp_tuple *imp;
    sor_tuple *sor;
    fun_tuple *fun;
    atm_tuple *atm;
    pro_tuple *pro;
    set_tuple *set;
    com_tuple *com;
    var_tuple *var;
    equ_tuple *equ;
    def_tuple *def;
    mod_tuple *mod;
    und_tuple *und;
};

#define	ADM	0
#define	SOR	1
#define	FUN	2
#define	ATM	3
#define	PRO	4
#define	SET	5
#define	COM	6
#define	VAR	7
#define	EQU	8
#define	DEF	9
#define	PRM	10
#define	REN	11
#define	BIN	12
#define	IMP	13
#define	MOD	14
#define	UND	15
#endif				/* XTILTYPE_H_INCLUDED */
