#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "xtiltype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "psf_exits.h"
#include "realkey.h"

typedef keytype *pkey;
typedef pkey tkar[DEF + 1];
typedef int nrkar[DEF + 1];

static tkar *real_key = NULL;
static int nr_mod = 0;
static nrkar *nr_key = NULL;

void add_real_key(key, ind)
    keytype key;
    struct indextype *ind;

{
    origintype o;
    tabletype t;
    keytype k;
    int j;

    o = ind->origin;
    t = ind->table;
    k = ind->key;
    if (o > nr_mod) {
	if (nr_mod == 0) {
	    real_key = PSF_NMALLOC(tkar, o + 1);
	    nr_key = PSF_NMALLOC(nrkar, o + 1);
	} else {
	    real_key = PSF_REALLOC(real_key, tkar, o + 1);
	    nr_key = PSF_REALLOC(nr_key, nrkar, o + 1);
	}
	while (nr_mod < o) {
	    nr_mod++;
	    for (j = 1; j <= DEF; j++) {
		real_key[nr_mod][j] = NULL;
		nr_key[nr_mod][j] = 0;
	    }
	}
    }
    if (k > nr_key[o][t]) {
	if (nr_key[o][t] == 0) {
	    real_key[o][t] = PSF_NMALLOC(keytype, k + 1);
	} else {
	    real_key[o][t] =
		PSF_REALLOC(real_key[o][t], keytype, k + 1);
	}
	nr_key[o][t] = k;
    }
    real_key[o][t][k] = key;
}

keytype get_real_key(ind)
    struct indextype *ind;

{
    return (real_key[ind->origin][ind->table][ind->key]);
}

static tkar *mod_real_key = NULL;
static int mod_nr_mod = 0;
static nrkar *mod_nr_key = NULL;

static void mod_add_real_key(key, o, t, k)
    keytype key;
    origintype o;
    tabletype t;
    keytype k;

{
    int j;

    if (o > mod_nr_mod) {
	if (mod_nr_mod == 0) {
	    mod_real_key = PSF_NMALLOC(tkar, o + 1);
	    mod_nr_key = PSF_NMALLOC(nrkar, o + 1);
	} else {
	    mod_real_key = PSF_REALLOC(mod_real_key, tkar, o + 1);
	    mod_nr_key = PSF_REALLOC(mod_nr_key, nrkar, o + 1);
	}
	while (mod_nr_mod < o) {
	    mod_nr_mod++;
	    for (j = 1; j <= DEF; j++) {
		mod_real_key[mod_nr_mod][j] = NULL;
		mod_nr_key[mod_nr_mod][j] = 0;
	    }
	}
    }
    if (k > mod_nr_key[o][t]) {
	if (mod_nr_key[o][t] == 0) {
	    mod_real_key[o][t] = PSF_NMALLOC(keytype, k + 1);
	} else {
	    mod_real_key[o][t] =
		PSF_REALLOC(mod_real_key[o][t], keytype, k + 1);
	}
	mod_nr_key[o][t] = k;
    }
    mod_real_key[o][t][k] = key;
}

void module_add_real_key(mod)
    struct module *mod;

{
    int i;

    for (i = 1; i <= mod->entries_table[SOR]; i++)
	mod_add_real_key(i, mod->sor[i].o, SOR, mod->sor[i].k);
    for (i = 1; i <= mod->entries_table[FUN]; i++)
	mod_add_real_key(i, mod->fun[i].o, FUN, mod->fun[i].k);
    for (i = 1; i <= mod->entries_table[ATM]; i++)
	mod_add_real_key(i, mod->atm[i].o, ATM, mod->atm[i].k);
    for (i = 1; i <= mod->entries_table[PRO]; i++)
	mod_add_real_key(i, mod->pro[i].o, PRO, mod->pro[i].k);
    for (i = 1; i <= mod->entries_table[SET]; i++)
	mod_add_real_key(i, mod->set[i].o, SET, mod->set[i].k);
    for (i = 1; i <= mod->entries_table[COM]; i++)
	mod_add_real_key(i, mod->com[i].o, COM, mod->com[i].k);
    for (i = 1; i <= mod->entries_table[VAR]; i++)
	mod_add_real_key(i, mod->var[i].o, VAR, mod->var[i].k);
    for (i = 1; i <= mod->entries_table[EQU]; i++)
	mod_add_real_key(i, mod->equ[i].o, EQU, mod->equ[i].k);
    for (i = 1; i <= mod->entries_table[DEF]; i++)
	mod_add_real_key(i, mod->def[i].o, DEF, mod->def[i].k);
}

keytype module_get_real_key(ind)
    struct indextype *ind;

{
    return (mod_real_key[ind->origin][ind->table][ind->key]);
}
