#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "psf_prototype.h"
#include "psf_malloc.h"
#include "psf_standards.h"
#include "psf_exits.h"
#include "xtiltype.h"
#include "readxtiltype.h"
#include "readxtil.h"
#include "realkey.h"
#include "readexp.h"

extern FILE *input;
extern int linepos;
extern int lineno;
unsigned int max_entries[MTABLE];

void init_module(mod, mod_t)
    struct module *mod;
    int mod_t;
{
    int i;

    mod->name = NULL;
    for (i = 0; i < MTABLE; i++) {
	mod->entries_table[i] = 0;
	if (mod_t)
	    max_entries[i] = 1;
    }
    if (mod_t) {
	mod->adm = PSF_MALLOC(adm_tuple);
	mod->sor = PSF_MALLOC(sor_tuple);
	mod->fun = PSF_MALLOC(fun_tuple);
	mod->atm = PSF_MALLOC(atm_tuple);
	mod->pro = PSF_MALLOC(pro_tuple);
	mod->set = PSF_MALLOC(set_tuple);
	mod->com = PSF_MALLOC(com_tuple);
	mod->var = PSF_MALLOC(var_tuple);
	mod->equ = PSF_MALLOC(equ_tuple);
	mod->def = PSF_MALLOC(def_tuple);
	mod->par = PSF_MALLOC(par_tuple);
	mod->ren = PSF_MALLOC(ren_tuple);
	mod->bin = PSF_MALLOC(bin_tuple);
	mod->imp = PSF_MALLOC(imp_tuple);
	mod->mod = PSF_MALLOC(mod_tuple);
	mod->und = PSF_MALLOC(und_tuple);
    }
}

static void alloc_table(tnr, mod, entries)
    tabletype tnr;
    struct module *mod;
    unsigned int entries;
{
    switch (tnr) {
    case SOR:
	mod->sor = PSF_NMALLOC(sor_tuple, entries + 1);
	break;
    case FUN:
	mod->fun = PSF_NMALLOC(fun_tuple, entries + 1);
	break;
    case ATM:
	mod->atm = PSF_NMALLOC(atm_tuple, entries + 1);
	break;
    case PRO:
	mod->pro = PSF_NMALLOC(pro_tuple, entries + 1);
	break;
    case SET:
	mod->set = PSF_NMALLOC(set_tuple, entries + 1);
	break;
    case COM:
	mod->com = PSF_NMALLOC(com_tuple, entries + 1);
	break;
    case VAR:
	mod->var = PSF_NMALLOC(var_tuple, entries + 1);
	break;
    case EQU:
	mod->equ = PSF_NMALLOC(equ_tuple, entries + 1);
	break;
    case DEF:
	mod->def = PSF_NMALLOC(def_tuple, entries + 1);
	break;
    case PRM:
	mod->par = PSF_NMALLOC(par_tuple, entries + 1);
	break;
    case REN:
	mod->ren = PSF_NMALLOC(ren_tuple, entries + 1);
	break;
    case BIN:
	mod->bin = PSF_NMALLOC(bin_tuple, entries + 1);
	break;
    case IMP:
	mod->imp = PSF_NMALLOC(imp_tuple, entries + 1);
	break;
    case MOD:
	mod->mod = PSF_NMALLOC(mod_tuple, entries + 1);
	break;
    case UND:
	mod->und = PSF_NMALLOC(und_tuple, entries + 1);
	break;
    }
}

void enlarge_entries(tnr, mod)
    tabletype tnr;
    struct module *mod;
{
    max_entries[tnr] *= 2;
    switch (tnr) {
    case ADM:
	mod->adm = PSF_REALLOC(mod->adm, adm_tuple, max_entries[tnr]);
	break;
    case SOR:
	mod->sor = PSF_REALLOC(mod->sor, sor_tuple, max_entries[tnr]);
	break;
    case FUN:
	mod->fun = PSF_REALLOC(mod->fun, fun_tuple, max_entries[tnr]);
	break;
    case ATM:
	mod->atm = PSF_REALLOC(mod->atm, atm_tuple, max_entries[tnr]);
	break;
    case PRO:
	mod->pro = PSF_REALLOC(mod->pro, pro_tuple, max_entries[tnr]);
	break;
    case SET:
	mod->set = PSF_REALLOC(mod->set, set_tuple, max_entries[tnr]);
	break;
    case COM:
	mod->com = PSF_REALLOC(mod->com, com_tuple, max_entries[tnr]);
	break;
    case VAR:
	mod->var = PSF_REALLOC(mod->var, var_tuple, max_entries[tnr]);
	break;
    case EQU:
	mod->equ = PSF_REALLOC(mod->equ, equ_tuple, max_entries[tnr]);
	break;
    case DEF:
	mod->def = PSF_REALLOC(mod->def, def_tuple, max_entries[tnr]);
	break;
    case PRM:
	mod->par = PSF_REALLOC(mod->par, par_tuple, max_entries[tnr]);
	break;
    case REN:
	mod->ren = PSF_REALLOC(mod->ren, ren_tuple, max_entries[tnr]);
	break;
    case BIN:
	mod->bin = PSF_REALLOC(mod->bin, bin_tuple, max_entries[tnr]);
	break;
    case IMP:
	mod->imp = PSF_REALLOC(mod->imp, imp_tuple, max_entries[tnr]);
	break;
    case MOD:
	mod->mod = PSF_REALLOC(mod->mod, mod_tuple, max_entries[tnr]);
	break;
    case UND:
	mod->und = PSF_REALLOC(mod->und, und_tuple, max_entries[tnr]);
	break;
    }
}

void read_entries(tnr, mod, entries, mod_t)
    tabletype tnr;
    struct module *mod;
    unsigned int entries;
    int mod_t;
{
    int i;
    struct indextype dummy_ind;

    for (i = 1; i <= entries; i++) {
	if (mod_t)
	    if (++mod->entries_table[tnr] == max_entries[tnr])
		enlarge_entries(tnr, mod);
	read_index(&dummy_ind);
	if ((!mod_t) && tnr <= DEF)
	    add_real_key(i, &dummy_ind);
	switch (tnr) {
	case SOR:
	    read_sor_tuple(&mod->sor[i]);
	    mod->sor[i].o = dummy_ind.origin;
	    mod->sor[i].k = dummy_ind.key;
	    break;
	case FUN:
	    read_fun_tuple(&mod->fun[i]);
	    mod->fun[i].o = dummy_ind.origin;
	    mod->fun[i].k = dummy_ind.key;
	    break;
	case ATM:
	    read_atm_tuple(&mod->atm[i]);
	    mod->atm[i].o = dummy_ind.origin;
	    mod->atm[i].k = dummy_ind.key;
	    break;
	case PRO:
	    read_pro_tuple(&mod->pro[i]);
	    mod->pro[i].o = dummy_ind.origin;
	    mod->pro[i].k = dummy_ind.key;
	    break;
	case SET:
	    read_set_tuple(&mod->set[i]);
	    mod->set[i].o = dummy_ind.origin;
	    mod->set[i].k = dummy_ind.key;
	    break;
	case COM:
	    read_com_tuple(&mod->com[i]);
	    mod->com[i].o = dummy_ind.origin;
	    mod->com[i].k = dummy_ind.key;
	    break;
	case VAR:
	    read_var_tuple(&mod->var[i]);
	    mod->var[i].o = dummy_ind.origin;
	    mod->var[i].k = dummy_ind.key;
	    break;
	case EQU:
	    read_equ_tuple(&mod->equ[i]);
	    mod->equ[i].o = dummy_ind.origin;
	    mod->equ[i].k = dummy_ind.key;
	    break;
	case DEF:
	    read_def_tuple(&mod->def[i]);
	    mod->def[i].o = dummy_ind.origin;
	    mod->def[i].k = dummy_ind.key;
	    break;
	case PRM:
	    read_par_tuple(&mod->par[i]);
	    mod->par[i].o = dummy_ind.origin;
	    mod->par[i].k = dummy_ind.key;
	    break;
	case REN:
	    read_ren_tuple(&mod->ren[i]);
	    break;
	case BIN:
	    read_bin_tuple(&mod->bin[i]);
	    break;
	case IMP:
	    read_imp_tuple(&mod->imp[i]);
	    break;
	case MOD:
	    read_mod_tuple(&mod->mod[i]);
	    break;
	case UND:
	    read_und_tuple(&mod->und[i]);
	    break;
	}
    }
}

bool end_of_module()
{
    int c;

    skip_space();
    c = getc(input);
    ungetc(c, input);
    if (c == 'e') {
	read_string("end");
	skip_space();
	return TRUE;
    }
    if (c == EOF) {
	SYNTAX_ERROR("EOF found, \"table\" or \"end\" expected");
	exit(EXIT_SYNTAX_ERR);
    }
    return FALSE;
}

int read_module(mod, mod_t, fp)
    struct module *mod;
    int mod_t;
    FILE *fp;
{
    unsigned int tnr, entries;
    char tid;
    char *s;
    int ic, size, bufsize;

#ifndef THIS_IS_ITIL_TIL
    set_read_type(mod_t);	/* mtil  1 or itil 0 module */
#endif

    set_input_file(fp);		/* readxtiltype`input_file = fp; */
    linepos = 0;
    lineno = 1;
    skip_space();
    ic = getc(input);
    if (ic == EOF)
	return 1;
    else
	ungetc(ic, input);
    read_string("module");
    init_module(mod, mod_t);
    skip_space();
    s = PSF_NMALLOC(char, 1);
    bufsize = 1;
    size = 0;
    while (!isspace(ic = getc(input)) && ic != '{') {
	linepos++;
	if (ic == EOF) {
	    if (size == 0)
		SYNTAX_ERROR("found EOF, expecting module name");
	    else
		SYNTAX_ERROR("found EOF, expecting rest of module name");
	    exit(EXIT_SYNTAX_ERR);
	}
	*(s + size) = (char) ic;
	size++;
	if (size >= bufsize) {
	    bufsize += 10;
	    s = PSF_REALLOC(s, char, bufsize + 1);
	}
    }
    if (ic == '{')
	ungetc(ic, input);
    else if (ic == '\n') {
	linepos = 0;
	lineno++;
    } else
	linepos++;
    s = PSF_REALLOC(s, char, size + 1);
    *(s + size) = '\0';

#ifdef READDEBUG
    fprintf(stderr, "%s", s);
#endif

    mod->name = s;
    mod->ff = mod_t ? read_freeformat() : NULL;

    set_read_current_module(mod);
    while (!end_of_module()) {
	read_string("table");
	skip_space();
	tid = getc(input);
	linepos++;

#ifdef READDEBUG
	fprintf(stderr, "%c", tid);
#endif

	tnr = table_nr(tid);
	read_char('#');
	entries = read_nat();
	if (!mod_t)
	    alloc_table(tnr, mod, entries);

	if (!mod_t)
	    mod->entries_table[tnr] = entries;
	read_entries(tnr, mod, entries, mod_t);
	read_string("end");
    }
    return (0);
}
