#ifndef TILTYPE_H
#define TILTYPE_H

/*
 * type definitions for reading and modifying free format
 */

typedef struct char_map {
    char c;
    char *s;
} char_map;

/*
 *
 *   type definitions for the TIL code
 *
 */

typedef unsigned int tabletype;
typedef int keytype;

typedef struct indextype {
    tabletype table;
    keytype key;
} indextype;

typedef unsigned int arity;

typedef struct indexlist {
    arity a;
    indextype *indlist;
} indexlist;

#ifdef NEWFF
typedef struct new_freeformat {
    char *tag;
    char *info;
    struct new_freeformat *next;
} *freeformat;
#else
typedef char *freeformat;
#endif				/* NEWFF */

typedef char tag;

typedef struct ff_tuple {
    freeformat ff;
} adm_tuple, sor_tuple;

typedef struct fun_tuple {
    struct indexlist sor_indlist;
    struct indexlist return_list;
    freeformat ff;
} fun_tuple;

typedef struct atm_tuple {
    struct indexlist sor_indlist;
    freeformat ff;
} atm_tuple, pro_tuple;

#define TUPLE	'<'
#define TERM	'['

typedef struct ae_term {
    tag t;
    indextype ind;
    arity a;
    struct ae_term *ae_list;
} ae_term;

typedef struct s_term {
    char fun;
    arity a;
    int *u_tag;
    union terms {
	struct ae_term *ae_t;	/* u_tag == 0 */
	struct s_term *s_t;	/* u_tag == 1 */
    } *arr;
} s_term;

#define UNI		'+'
#define INT		'.'
#define DIF		'\\'
#define ENU		':'

typedef struct set_tuple {
    indextype ind;
    int u_tag;
    union construction {
	indextype sort;		/* u_tag == 0 */
	struct s_term set_term;	/* u_tag == 1 */
    } construct;
    freeformat ff;
} set_tuple;

typedef struct com_tuple {
    struct ae_term aet[3];
    freeformat ff;
} com_tuple;

typedef struct var_tuple {
    indextype ind;
    freeformat ff;
} var_tuple;

typedef struct equation {
    struct ae_term aet1;
    struct ae_term aet2;
} equation;

typedef struct equ_tuple {
    struct ae_term aet1;
    struct ae_term aet2;
    arity a;
    struct equation *guard;
    freeformat ff;
} equ_tuple;

#define AET	'\0'
#define SKP	'i'
#define ALT	'a'
#define SEQ	's'
#define PAR	'p'
#define SUM	'A'
#define MRG	'P'
#define ENC	'e'
#define HID	'h'
#define IF	'f'
#define DLK	'd'

#define INTR	'I'
#define DISR	'D'
#define PRIO	'R'

#define STAR	'K'
#define SHARP	'S'

#ifdef VERIFY
#define LMRG	'l'
#define CMM	'c'
/* deadlock DLK, left-merge LMRG, communication CMM added for STEP */
#endif	/* VERIFY */

typedef struct process_expr {
    char fun;			/* one of the constants above */
    union {
	int nr;			/* to distinguish skips */
	struct {
	    indextype ind;
	    struct process_expr *pe;
	} pe1;			/* fun is one of SUM MRG ENC HID */
	struct ae_term pe2;	/* fun is one of AET */
	struct {
	    arity a;
	    struct process_expr *pe;
	} pe3;			/* fun is one of ALT SEQ PAR INTR DISR */
				/* STAR SHARP */
	struct {
	    struct ae_term aex;
	    struct ae_term aey;
	    struct process_expr *pe;
	} pe4;			/* fun is one of IF */
	struct {
	    struct indexlist sets;
	    struct process_expr *pe;
	} pe5;			/* fun is one of PRIO */
    } proc_expr;
} process_expr;

typedef struct def_tuple {
    struct ae_term ae_t;
    struct process_expr p_expr;
    freeformat ff;
} def_tuple;

#ifdef EXTTIL
typedef struct dataed_tuple {
    struct ae_term aet;
    freeformat ff;
} dataed_tuple;

typedef struct proced_tuple {
    struct process_expr p_expr;
    freeformat ff;
} proced_tuple;

#endif				/* EXTTIL */

#define ADM	0
#define SOR	1
#define FUN	2
#define ATM	3
#define PRO	4
#define SET	5
#define COM	6
#define VAR	7
#define EQU	8
#define DEF	9

#ifdef	EXTTIL
#define DATAED	10
#define PROCED	11
#define MTABLE		12
#else				/* EXTTIL */
#define MTABLE		10
#endif				/* EXTTIL */

typedef struct module {
    char *name;
    unsigned int entries_table[MTABLE];
    adm_tuple *adm;
    sor_tuple *sor;
    fun_tuple *fun;
    atm_tuple *atm;
    pro_tuple *pro;
    set_tuple *set;
    com_tuple *com;
    var_tuple *var;
    equ_tuple *equ;
    def_tuple *def;

#ifdef EXTTIL
    dataed_tuple *dataed;
    proced_tuple *proced;
#endif				/* EXTTIL */
} module;

#endif				/* TILTYPE_H */
