#include <stdio.h>		/* to define FILE */
#include <setjmp.h>		/* to define jmp_buf */
#include "tiltype.h"		/* to define freeformat */
#include "psf_standards.h"	/* to define bool */

extern FILE *input;		/* open a TIL file for reading on this FILE
				 * before calling any of the functions below */

/* readtiltype.c */
extern bool no_illegal_chars;	/* remap odd characters to PSF identifiers */
extern bool psf_double_quotes;	/* ignore all double quotes in input */

extern void set_read_current_module PROTO_ARGS((struct module *mod));
extern void read_index PROTO_ARGS((struct indextype *index));
extern struct indextype *read_indexarr PROTO_ARGS((unsigned int nr));
extern void read_indexlist PROTO_ARGS((struct indexlist *il));
extern char *adjust_spaces PROTO_ARGS((char *ff));
extern freeformat read_freeformat PROTO_ARGS((void));
extern void read_ae_term PROTO_ARGS((ae_term *term));
extern void read_s_term PROTO_ARGS((struct s_term *term));
extern void reset_skip_nr PROTO_ARGS((void));
extern void read_process_expr PROTO_ARGS((struct process_expr *p_expr));
extern void read_sor_tuple PROTO_ARGS((sor_tuple *sor_t));
extern void read_fun_tuple PROTO_ARGS((fun_tuple *fun_t));
extern void read_atm_tuple PROTO_ARGS((atm_tuple *atm_t));
extern void read_pro_tuple PROTO_ARGS((pro_tuple *pro_t));
extern void read_set_tuple PROTO_ARGS((set_tuple *set_t));
extern void read_com_tuple PROTO_ARGS((com_tuple *com_t));
extern void read_var_tuple PROTO_ARGS((var_tuple *var_t));
extern void read_equ_tuple PROTO_ARGS((equ_tuple *equ_t));
extern void read_def_tuple PROTO_ARGS((def_tuple *def_t));
extern void read_adm_tuple PROTO_ARGS((adm_tuple *adm_t));

#ifdef EXTTIL
void read_dataed_tuple PROTO_ARGS((dataed_tuple *));
void read_proced_tuple PROTO_ARGS((proced_tuple *));
#endif				/* EXTTIL */
