.TH "readtil" 3  "Sep 16, 1993" "PSF-Toolkit"
.SH NAME readtil - TIL scanner/parser
 
.SH readtil

.SS OVERVIEW
Since several tools operate on til a readtil is provided. It comprises of several files which read til and create a data structure.
.SS DESCRIPTION
The main interface is given by the file readtil.h.
To use this first the file tiltype.h should be included.
The til code is read by first opening a file (FILE*)input,
and than reading this file by a call of read_module((struct module *)module).
If errors occur it returns 1 otherwise it returns 0. 
For the handling of malloc and syntax errors the (char *) progname and filename
must be defined.

The file fieldex.c contains a functions field_extract, which extracts a field from a free format.
It is applied as field_extract((char *) field,(char *)free_format, tabletype table, keytype key).
And returns the fields value or a default value if the field is not found.

Depending on certain switches each free_format is filtered ,
these switches are declared in readtiltype.c
as
.nf
bool psf_non_ident_chars = FALSE;
bool psf_double_quotes = FALSE;
.fi
If psf_double_quotes " are ignored.
If psf_ident_chars those characters are filtered out and replaced
by a name as defined in the following table, except for possibly
ignored double quotes.
.nf
<space> 'spa'
!       'exc'
"       'dqu'
#       'hsh'
$       'dlr'
%       'prc'
&       'amp'
'       'squ'
(       'lpa'
)       'rpa'
*       'ast'
+       'pls'
.       'dot'
,       'cma'
/       'fsl'
:       'col'
;       'sco'
<       'lth'
=       'eql'
>       'grt'
?       'que'
@       'ats'
[       'lbr'
\\       'bsl'
]       'rbr'
^       'hat'
_       'und'
`       'bqu'
{       'lac'
|       'bar'
}       'rac'
~       'tld'
.fi
Other not PSF-identifier characters are replaced by their decimal value.
 

.SS FILES
fieldex.c
fieldex.h
readexp.c
readexp.h
readtil.c
readtil.files
readtil.h
readtil.imake
readtiltype.c
readtiltype.h
tiltype.h
.SS DIAGNOSTICS
.SS BUGS
.SH SEE ALSO

