#include <setjmp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "psf_prototype.h"

#include "readexp.h"
#include "tiltype.h"
#include "readtil.h"
#include "readtiltype.h"

#include "psf_exits.h"
#include "psf_malloc.h"
#include "psf_standards.h"

static unsigned int max_entries[MTABLE];

FILE *input;

void set_input_file(fp)
    FILE *fp;
{
    input = fp;
}

static void init_module(mod)
    struct module *mod;
{
    int i;

    lineno = 1;
    linepos = 0;
    for (i = 0; i < MTABLE; i++) {
	mod->entries_table[i] = 0;
	max_entries[i] = 1;
    }
    mod->adm = PSF_MALLOC(adm_tuple);
    mod->adm[0].ff = NULL;
    mod->sor = PSF_MALLOC(sor_tuple);
    mod->sor[0].ff = NULL;
    mod->fun = PSF_MALLOC(fun_tuple);
    mod->fun[0].ff = NULL;
    mod->atm = PSF_MALLOC(atm_tuple);
    mod->atm[0].ff = NULL;
    mod->pro = PSF_MALLOC(pro_tuple);
    mod->pro[0].ff = NULL;
    mod->set = PSF_MALLOC(set_tuple);
    mod->set[0].ff = NULL;
    mod->com = PSF_MALLOC(com_tuple);
    mod->com[0].ff = NULL;
    mod->var = PSF_MALLOC(var_tuple);
    mod->var[0].ff = NULL;
    mod->equ = PSF_MALLOC(equ_tuple);
    mod->equ[0].ff = NULL;
    mod->def = PSF_MALLOC(def_tuple);
    mod->def[0].ff = NULL;

#ifdef	EXTTIL
    mod->dataed = PSF_MALLOC(dataed_tuple);
    mod->dataed[0].ff = NULL;
    mod->proced = PSF_MALLOC(proced_tuple);
    mod->proced[0].ff = NULL;
#endif
}

static void resize(mod)
    struct module *mod;
{
    int tnr;

    for (tnr = 0; tnr < MTABLE; tnr++)
	switch (tnr) {
	case ADM:
	    mod->adm = PSF_REALLOC(mod->adm, adm_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case SOR:
	    mod->sor = PSF_REALLOC(mod->sor, sor_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case FUN:
	    mod->fun = PSF_REALLOC(mod->fun, fun_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case ATM:
	    mod->atm = PSF_REALLOC(mod->atm, atm_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case PRO:
	    mod->pro = PSF_REALLOC(mod->pro, pro_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case SET:
	    mod->set = PSF_REALLOC(mod->set, set_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case COM:
	    mod->com = PSF_REALLOC(mod->com, com_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case VAR:
	    mod->var = PSF_REALLOC(mod->var, var_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case EQU:
	    mod->equ = PSF_REALLOC(mod->equ, equ_tuple,
				   mod->entries_table[tnr] + 1);
	    break;
	case DEF:
	    mod->def = PSF_REALLOC(mod->def, def_tuple,
				   mod->entries_table[tnr] + 1);
	    break;

#ifdef	EXTTIL
	case DATAED:
	    mod->dataed = PSF_REALLOC(mod->dataed, dataed_tuple,
				      mod->entries_table[tnr] + 1);
	    break;
	case PROCED:
	    mod->proced = PSF_REALLOC(mod->proced, proced_tuple,
				      mod->entries_table[tnr] + 1);
	    break;
#endif
	}
}

static void enlarge_entries(tnr, new_index, mod)
    tabletype tnr;
    keytype new_index;		/* index of newly read item */
    struct module *mod;
{
    int old_size, i;

    old_size = max_entries[tnr];
    while (max_entries[tnr] <= new_index)
	max_entries[tnr] *= 2;
    switch (tnr) {
    case ADM:
	mod->adm = PSF_REALLOC(mod->adm, adm_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->adm[i].ff = NULL;
	break;
    case SOR:
	mod->sor = PSF_REALLOC(mod->sor, sor_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->sor[i].ff = NULL;
	break;
    case FUN:
	mod->fun = PSF_REALLOC(mod->fun, fun_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->fun[i].ff = NULL;
	break;
    case ATM:
	mod->atm = PSF_REALLOC(mod->atm, atm_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->atm[i].ff = NULL;
	break;
    case PRO:
	mod->pro = PSF_REALLOC(mod->pro, pro_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->pro[i].ff = NULL;
	break;
    case SET:
	mod->set = PSF_REALLOC(mod->set, set_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->set[i].ff = NULL;
	break;
    case COM:
	mod->com = PSF_REALLOC(mod->com, com_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->com[i].ff = NULL;
	break;
    case VAR:
	mod->var = PSF_REALLOC(mod->var, var_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->var[i].ff = NULL;
	break;
    case EQU:
	mod->equ = PSF_REALLOC(mod->equ, equ_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->equ[i].ff = NULL;
	break;
    case DEF:
	mod->def = PSF_REALLOC(mod->def, def_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->def[i].ff = NULL;
	break;

#ifdef	EXTTIL
    case DATAED:
	mod->dataed = PSF_REALLOC(mod->dataed, dataed_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->dataed[i].ff = NULL;
	break;
    case PROCED:
	mod->proced = PSF_REALLOC(mod->proced, proced_tuple, max_entries[tnr]);
	for (i = old_size; i < max_entries[tnr]; i++)
	    mod->proced[i].ff = NULL;
	break;
#endif
    }
}

void read_entry(tnr, mod, ent)
    tabletype tnr;
    struct module *mod;
    keytype ent;
{
    char s[sizeof "duplicate definition of '[0.123456890]'"];

    if (tnr < MTABLE) {
	if (mod->entries_table[tnr] < ent)
	    mod->entries_table[tnr] = ent;
	if (ent >= max_entries[tnr])
	    enlarge_entries(tnr, ent, mod);
    }
    switch (tnr) {
    case ADM:
	if (mod->adm[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_adm_tuple(&mod->adm[ent]);
	break;
    case SOR:
	if (mod->sor[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_sor_tuple(&mod->sor[ent]);
	break;
    case FUN:
	if (mod->fun[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_fun_tuple(&mod->fun[ent]);
	break;
    case ATM:
	if (mod->atm[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_atm_tuple(&mod->atm[ent]);
	break;
    case PRO:
	if (mod->pro[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_pro_tuple(&mod->pro[ent]);
	break;
    case SET:
	if (mod->set[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_set_tuple(&mod->set[ent]);
	break;
    case COM:
	if (mod->com[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_com_tuple(&mod->com[ent]);
	break;
    case VAR:
	if (mod->var[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_var_tuple(&mod->var[ent]);
	break;
    case EQU:
	if (mod->equ[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_equ_tuple(&mod->equ[ent]);
	break;
    case DEF:
	if (mod->def[ent].ff != NULL) {
	    (void) sprintf(s, "duplicate definition of '[%u.%u]'", tnr, ent);
	    SYNTAX_ERROR(s);
	}
	read_def_tuple(&mod->def[ent]);
	break;
    default:
	(void) fprintf(stderr, "%s: I'm expecting TIL code\n", progname);
	(void) sprintf(s, "unknown entry type \"[%u.%u]\"", tnr, ent);
	SYNTAX_ERROR(s);
	exit(EXIT_HELP);
    }
}

int read_module(mod, fp)
    struct module *mod;
    FILE *fp;
{
    tabletype tnr;
    keytype entry;
    int ic;

    if (progname == NULL)
	progname = "readtil";
    if (filename == NULL)
	filename = "til_file";
    input = fp;
    init_module(mod);
    set_read_current_module(mod);
    reset_skip_nr();

    skip_space();
    while ((ic = getc(input)) != EOF) {
	PSF_ASSERT(ungetc(ic, input)!=EOF);
	read_char('[');
	tnr = (tabletype) read_nat();
	read_char('.');
	entry = (keytype) read_nat();
	read_char(']');

	if (entry < 0) {
	    char s[sizeof "index too large: 1234567890"];
	    (void) sprintf(s, "index too large: %u", entry);
	    SYNTAX_ERROR(s);
	    exit(EXIT_SYNTAX_ERR);
	}

	read_entry(tnr, mod, entry);
	skip_space();
    }
    resize(mod);
    return 0;
}
