#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef NEWFF
#include <string.h>
#endif

#include "psf_prototype.h"

#include "tiltype.h"
#include "fieldex.h"
#include "psf_malloc.h"
#include "psf_standards.h"

static char *field_table[] =
{"ADM", "SOR", "FUN", "ATM", "PRO", "SET", "COM", "VAR", "EQU", "DEF", "UND"};

#define LEN_TABLE (sizeof field_table/sizeof field_table[0])
#define OK(table) ((table) > LEN_TABLE ? LEN_TABLE : (table))

#define BIG_ENOUGH(str) (sizeof "1234567890 FUN-1234567890-" + strlen(str))

static char *buffer =  NULL;

static char *default_buffer(str, table, key)
    char *str;
    tabletype table;
    keytype key;
{
    if (buffer == NULL)
	buffer = PSF_NMALLOC(char, BIG_ENOUGH(str));
    else
	buffer = PSF_REALLOC(buffer, char, BIG_ENOUGH(str));
    if (str[0] == 'm' ) 
	(void) sprintf(buffer, "%i %s-%i-%s", key, field_table[OK(table)],
		       key, str);
    else
	(void) sprintf(buffer, "%s-%i-%s", field_table[OK(table)], key, str);
    return buffer;
}

/* REMARK
 * if a field is empty info should contain the NULL-string instead of NULL.
 * Bob.
 */

#ifdef NEWFF
char *field_extract(str, ff, table, key)
    char *str;
    freeformat ff;
    tabletype table;
    keytype key;
{
    if (ff == NULL)
	return default_buffer(str, table, key);
    if (strcmp(str, ff->tag) == 0 && ff->info)
	return ff->info;
    else
	return field_extract(str, ff->next, table, key);
}

#else	/* NEWFF */
char *field_extract(str, ff, table, key)
    char *str;
    freeformat ff;
    tabletype table;
    keytype key;
{
    char *cp;

    PSF_ASSERT(str != NULL);
    if (ff == NULL)
	return default_buffer(str, table, key);
    if (buffer == NULL)
	buffer = PSF_NMALLOC(char, strlen(ff));
    else
	buffer = PSF_REALLOC(buffer, char, strlen(ff));

    while (1) {
	while (*ff != '<')
	    if (*ff++ == '\0')
		return default_buffer(str, table, key);
	ff++;
	for (cp = str; *cp == *ff; cp++, ff++)
	    ;
	if (*cp != '\0' || *ff != '>')
	    continue;
	ff++;
	for (cp = buffer; *ff != '\0' && *ff != '<' && *ff != '}';)
	    *cp++ = *ff++;
	*cp = '\0';
	return (buffer);
    }
}
#endif				/* NEWFF */

/*
 * This function is added, because one simple wants the field or NULL
 * if it does not exists.
 */
char * get_ff_field(str, ff)
char *str;
freeformat ff;
{
#ifdef NEWFF
    while (ff != NULL) {
	if (strcmp(str, ff->tag) == 0)
	    return(ff->info);
	ff = ff->next;
    }
    return(NULL);
#else /* NEWFF */
    char *p;
    int n;

    p = ff;
    n = strlen(str);

    while (1) {
	while (*p != '<') {
	    p ++;
	    if (*p == '\0')
		return(NULL);
	}
	if (strncmp(str, p + 1, n) == 0)
	    return(p + n + 2);
	p ++;
    }
#endif /* NEWFF */
}
